/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.integration.crafttweaker.BaseAction;
import com.denfop.integration.crafttweaker.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.utils.ModUtils;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialupgrade.AlloySmelter")
@ModOnly(value="industrialupgrade")
@ZenRegister
public class CTAlloySmelter {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient container, IIngredient fill, Short temperature) {
        CraftTweakerAPI.apply((IAction)new AddAlloSmelterIngredientAction(container, fill, output, temperature));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveAlloSmelterIngredientAction(output));
    }

    private static class RemoveAlloSmelterIngredientAction
    extends BaseAction {
        private final IItemStack output;

        public RemoveAlloSmelterIngredientAction(IItemStack output) {
            super("alloysmelter");
            this.output = output;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            Recipes.recipes.addRemoveRecipe("alloysmelter", RemoveAlloSmelterIngredientAction.getItemStack(this.output));
        }

        @Override
        public String describe() {
            return "removing alloy smelter recipe " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RemoveAlloSmelterIngredientAction other = (RemoveAlloSmelterIngredientAction)obj;
            return Objects.equals(this.output, other.output);
        }
    }

    private static class AddAlloSmelterIngredientAction
    extends BaseAction {
        private final IIngredient container;
        private final IIngredient fill;
        private final IItemStack output;
        private final short temperature;

        public AddAlloSmelterIngredientAction(IIngredient container, IIngredient fill, IItemStack output, Short temperature) {
            super("alloysmelter");
            this.container = container;
            this.fill = fill;
            this.output = output;
            this.temperature = temperature;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            String ore = "";
            String ore1 = "";
            NBTTagCompound nbt = ModUtils.nbt();
            nbt.func_74777_a("temperature", this.temperature);
            ItemStack stack = new InputItemStack(this.container).getInputs().get(0);
            int amount = new InputItemStack(this.container).getAmount();
            if (OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
                ore = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[0]);
            }
            stack = new InputItemStack(this.fill).getInputs().get(0);
            int amount1 = new InputItemStack(this.fill).getAmount();
            if (OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
                ore1 = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[0]);
            }
            Recipes.recipes.addAdderRecipe("alloysmelter", new BaseMachineRecipe(new Input(OreDictionary.getOres((String)ore).isEmpty() ? new InputItemStack(this.container) : new InputOreDict(ore, amount), OreDictionary.getOres((String)ore1).isEmpty() ? new InputItemStack(this.fill) : new InputOreDict(ore1, amount1)), new RecipeOutput(nbt, AddAlloSmelterIngredientAction.getItemStack(this.output))));
        }

        @Override
        public String describe() {
            return "Adding alloy smelter recipe " + this.container + " + " + this.fill + " => " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.container != null ? this.container.hashCode() : 0);
            hash = 67 * hash + (this.fill != null ? this.fill.hashCode() : 0);
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddAlloSmelterIngredientAction other = (AddAlloSmelterIngredientAction)obj;
            if (!Objects.equals(this.container, other.container)) {
                return false;
            }
            if (!Objects.equals(this.fill, other.fill)) {
                return false;
            }
            return Objects.equals(this.output, other.output);
        }
    }
}

