/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.integration.crafttweaker.BaseAction;
import com.denfop.integration.crafttweaker.InputItemStack;
import com.denfop.utils.ModUtils;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialupgrade.EndAssembler")
@ModOnly(value="industrialupgrade")
@ZenRegister
public class CTEndTransformer {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient fill, Double matter) {
        CraftTweakerAPI.apply((IAction)new AddAlloSmelterIngredientAction(fill, output, matter));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveAlloSmelterIngredientAction(output));
    }

    private static class RemoveAlloSmelterIngredientAction
    extends BaseAction {
        private final IItemStack output;

        public RemoveAlloSmelterIngredientAction(IItemStack output) {
            super("endassembler");
            this.output = output;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            Recipes.recipes.addRemoveRecipe("endcollector", CraftTweakerMC.getItemStack((IItemStack)this.output));
        }

        @Override
        public String describe() {
            return "removing ender transformer recipe " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RemoveAlloSmelterIngredientAction other = (RemoveAlloSmelterIngredientAction)obj;
            return Objects.equals(this.output, other.output);
        }
    }

    private static class AddAlloSmelterIngredientAction
    extends BaseAction {
        private final IIngredient container;
        private final IItemStack output;
        private final double matter;

        public AddAlloSmelterIngredientAction(IIngredient container, IItemStack output, Double matter) {
            super("endassembler");
            this.container = container;
            this.output = output;
            this.matter = matter;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            NBTTagCompound nbt = ModUtils.nbt();
            nbt.func_74780_a("need", this.matter);
            InputItemStack stack = new InputItemStack(this.container);
            Recipes.recipes.addAdderRecipe("endcollector", new BaseMachineRecipe(new Input(stack), new RecipeOutput(nbt, AddAlloSmelterIngredientAction.getItemStack(this.output))));
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.container != null ? this.container.hashCode() : 0);
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddAlloSmelterIngredientAction other = (AddAlloSmelterIngredientAction)obj;
            if (!Objects.equals(this.container, other.container)) {
                return false;
            }
            return Objects.equals(this.output, other.output);
        }
    }
}

