/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.recipe.IInputItemStack;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InputItemStack
implements IInputItemStack {
    List<ItemStack> stacks = new ArrayList<ItemStack>();

    public InputItemStack(IIngredient ingredient) {
        ingredient.getItems().forEach(iItemStack -> this.stacks.add(CraftTweakerMC.getItemStack((IItemStack)iItemStack)));
    }

    @Override
    public boolean matches(ItemStack subject) {
        List<ItemStack> inputs = this.stacks;
        Item subjectItem = subject.func_77973_b();
        int subjectMeta = subject.func_77952_i();
        return inputs.stream().anyMatch(oreStack -> {
            Item oreItem = oreStack.func_77973_b();
            int metaRequired = oreStack.func_77952_i();
            return subjectItem == oreItem && (subjectMeta == metaRequired || metaRequired == Short.MAX_VALUE);
        });
    }

    @Override
    public int getAmount() {
        return this.stacks.get(0).func_190916_E();
    }

    @Override
    public void growAmount(int col) {
        this.stacks.forEach(stack -> stack.func_190917_f(col));
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.stacks;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.stacks.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputItemStack other = (InputItemStack)obj;
        return Objects.equals(this.stacks, other.stacks);
    }
}

