/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei;

import com.denfop.IUItem;
import com.denfop.recipes.ScrapboxRecipeManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class ScrapboxRecipeWrapper
implements IRecipeWrapper {
    private final Map.Entry<ItemStack, Float> entry;

    public ScrapboxRecipeWrapper(Map.Entry<ItemStack, Float> entry) {
        this.entry = entry;
    }

    public static List<ScrapboxRecipeWrapper> createRecipes() {
        ArrayList<ScrapboxRecipeWrapper> recipes = new ArrayList<ScrapboxRecipeWrapper>();
        for (Map.Entry<ItemStack, Float> itemStackFloatEntry : ScrapboxRecipeManager.instance.getDrops().entrySet()) {
            recipes.add(new ScrapboxRecipeWrapper(itemStackFloatEntry));
        }
        return recipes;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        float value = this.entry.getValue().floatValue();
        String text = (double)value < 0.001 ? "< 0.01" : "  " + String.format("%.2f", Float.valueOf(value * 100.0f));
        minecraft.field_71466_p.func_78276_b(text + "%", 86, 9, 0x404040);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)IUItem.scrapBox);
        ingredients.setOutput(ItemStack.class, (Object)this.entry.getKey());
    }
}

