/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.alkalineearthquarry;

import com.denfop.IUItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class AlkalineEarthQuarryHandler {
    private static final List<AlkalineEarthQuarryHandler> recipes = new ArrayList<AlkalineEarthQuarryHandler>();
    private final ItemStack input;
    private final double chance;
    private final ItemStack output;
    private final ItemStack mesh;

    public AlkalineEarthQuarryHandler(ItemStack input, double chance, ItemStack output, ItemStack mesh) {
        this.input = input;
        this.chance = chance;
        this.output = output;
        this.mesh = mesh;
    }

    public static List<AlkalineEarthQuarryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AlkalineEarthQuarryHandler.initRecipes();
        }
        return recipes;
    }

    public static AlkalineEarthQuarryHandler addRecipe(ItemStack input, double chance, ItemStack output, ItemStack mesh) {
        AlkalineEarthQuarryHandler recipe = new AlkalineEarthQuarryHandler(input, chance, output, mesh);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((Block)Blocks.field_150354_m), 0.5, new ItemStack((Block)IUItem.ore2, 1, 0), new ItemStack((Item)IUItem.ironMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((Block)Blocks.field_150354_m), 2.5, new ItemStack((Block)IUItem.ore2, 1, 0), new ItemStack((Item)IUItem.steelMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((Block)Blocks.field_150354_m), 4.0, new ItemStack((Block)IUItem.ore2, 1, 0), new ItemStack((Item)IUItem.boridehafniumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((Block)Blocks.field_150354_m), 5.0, new ItemStack((Block)IUItem.ore2, 1, 0), new ItemStack((Item)IUItem.vanadiumaluminumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack((Block)Blocks.field_150354_m), 7.0, new ItemStack((Block)IUItem.ore2, 1, 0), new ItemStack((Item)IUItem.steleticMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack(Blocks.field_150346_d), 0.5, new ItemStack((Block)IUItem.ore2, 1, 1), new ItemStack((Item)IUItem.steelMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack(Blocks.field_150346_d), 2.0, new ItemStack((Block)IUItem.ore2, 1, 1), new ItemStack((Item)IUItem.boridehafniumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack(Blocks.field_150346_d), 3.0, new ItemStack((Block)IUItem.ore2, 1, 1), new ItemStack((Item)IUItem.vanadiumaluminumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack(Blocks.field_150346_d), 4.0, new ItemStack((Block)IUItem.ore2, 1, 1), new ItemStack((Item)IUItem.steleticMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack(Blocks.field_150351_n), 0.5, new ItemStack((Block)IUItem.ore2, 1, 2), new ItemStack((Item)IUItem.steelMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack(Blocks.field_150351_n), 0.5, new ItemStack((Block)IUItem.ore2, 1, 2), new ItemStack((Item)IUItem.boridehafniumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack(Blocks.field_150351_n), 1.0, new ItemStack((Block)IUItem.ore2, 1, 2), new ItemStack((Item)IUItem.vanadiumaluminumMesh));
        AlkalineEarthQuarryHandler.addRecipe(new ItemStack(Blocks.field_150351_n), 2.0, new ItemStack((Block)IUItem.ore2, 1, 2), new ItemStack((Item)IUItem.steleticMesh));
    }

    public double getChance() {
        return this.chance;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getMesh() {
        return this.mesh;
    }
}

