/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.analyzer;

import com.denfop.IUItem;
import com.denfop.blocks.BlockHeavyOre;
import com.denfop.blocks.BlockMineral;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class AnalyzerHandler {
    private static final List<AnalyzerHandler> recipes = new ArrayList<AnalyzerHandler>();
    private final ItemStack input;

    public AnalyzerHandler(ItemStack input) {
        this.input = input;
    }

    public static List<AnalyzerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AnalyzerHandler.initRecipes();
        }
        return recipes;
    }

    public static AnalyzerHandler addRecipe(ItemStack input) {
        AnalyzerHandler recipe = new AnalyzerHandler(input);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BlockHeavyOre.Type type : BlockHeavyOre.Type.values()) {
            AnalyzerHandler.addRecipe(new ItemStack((Block)IUItem.heavyore, 1, type.getMetadata()));
        }
        for (Enum enum_ : BlockMineral.Type.values()) {
            AnalyzerHandler.addRecipe(new ItemStack((Block)IUItem.mineral, 1, ((BlockMineral.Type)enum_).getMetadata()));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }
}

