/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.antiupgradeblock;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AntiUpgradeBlockHandler {
    private static final List<AntiUpgradeBlockHandler> recipes = new ArrayList<AntiUpgradeBlockHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public AntiUpgradeBlockHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<AntiUpgradeBlockHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AntiUpgradeBlockHandler.initRecipes();
        }
        return recipes;
    }

    public static AntiUpgradeBlockHandler addRecipe(ItemStack input, ItemStack output) {
        AntiUpgradeBlockHandler recipe = new AntiUpgradeBlockHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static AntiUpgradeBlockHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (AntiUpgradeBlockHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("antiupgradeblock")) {
            AntiUpgradeBlockHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }
}

