/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.bee;

import com.denfop.blocks.mechanism.BlockHive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class BeeHandler {
    private static final List<BeeHandler> recipes = new ArrayList<BeeHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public BeeHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<BeeHandler> getRecipes() {
        if (recipes.isEmpty()) {
            BeeHandler.initRecipes();
        }
        return recipes;
    }

    public static BeeHandler addRecipe(ItemStack input, ItemStack output) {
        BeeHandler recipe = new BeeHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BlockHive container : BlockHive.values()) {
            BeeHandler.addRecipe(container.getDummyTe().getPickBlock(null, null), container.getDummyTe().getSelfDrops(0, false).get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

