/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.bf;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBlastFurnace;
import com.denfop.integration.jei.bf.BlastFWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlastFCategory
extends Gui
implements IRecipeCategory<BlastFWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;

    public BlastFCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guiblastfurnace_jei.png"), 5, 5, 168, 92);
    }

    @Nonnull
    public String getUid() {
        return BlockBlastFurnace.blast_furnace_main.func_176610_l() + "1";
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.blastfurnace, 1, 0).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        int xScale = (int)(38.0 * (double)this.progress / 100.0);
        if ((double)xScale >= 38.0) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(83, 41, 177, 19, xScale, 11);
    }

    public void setRecipe(IRecipeLayout layout, BlastFWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 57, 38);
        isg.set(0, recipes.getInput());
        IGuiFluidStackGroup fff = layout.getFluidStacks();
        fff.init(1, true, 5, 17, 12, 47, 10000, true, null);
        fff.set(1, new FluidStack(FluidRegistry.WATER, 1000));
        isg.init(2, false, 133, 39);
        isg.set(2, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiblastfurnace_jei.png");
    }
}

