/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.canning;

import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.canning.CanningRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class CanningCategory
extends Gui
implements IRecipeCategory<CanningRecipeWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public CanningCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guicanner_jei.png"), 5, 16, 140, 82);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine3.canner_iu.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(JEICompat.getBlockStack(BlockBaseMachine3.canner_iu).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        double xScale = 24.0f * (float)this.progress / 100.0f;
        if (xScale > 24.0) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(69, 7, 178, 9, (int)xScale, 16);
    }

    public void setRecipe(IRecipeLayout layout, CanningRecipeWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 36, 1);
        isg.set(0, recipes.getInput());
        isg.init(1, true, 74, 28);
        isg.set(1, recipes.getInput1());
        isg.init(2, false, 113, 1);
        isg.set(2, recipes.getOutput());
        if (recipes.getFluidstack() != null) {
            IGuiFluidStackGroup fff = layout.getFluidStacks();
            fff.init(0, true, 39, 27, 12, 47, 10000, true, null);
            fff.set(0, recipes.getFluidstack());
        }
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guicanner_jei.png");
    }
}

