/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.chemicalplant;

import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class ChemicalPlantHandler {
    private static final List<ChemicalPlantHandler> recipes = new ArrayList<ChemicalPlantHandler>();
    private final FluidStack input;
    private final FluidStack output;

    public ChemicalPlantHandler(FluidStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<ChemicalPlantHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ChemicalPlantHandler.initRecipes();
        }
        return recipes;
    }

    public static ChemicalPlantHandler addRecipe(FluidStack input, FluidStack output) {
        ChemicalPlantHandler recipe = new ChemicalPlantHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        ChemicalPlantHandler.addRecipe(new FluidStack(FluidName.fluidHelium.getInstance(), 2), new FluidStack(FluidName.fluidcryogen.getInstance(), 10));
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

