/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.chemicalplant;

import com.denfop.Localization;
import com.denfop.integration.jei.chemicalplant.ChemicalPlantHandler;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;

public class ChemicalPlantWrapper
implements IRecipeWrapper {
    private final FluidStack outputstack;
    private final FluidStack inputstack;

    public ChemicalPlantWrapper(ChemicalPlantHandler container) {
        this.inputstack = container.getInput();
        this.outputstack = container.getOutput();
    }

    public FluidStack getInputstack() {
        return this.inputstack;
    }

    public FluidStack getOutputstack() {
        return this.outputstack;
    }

    public List<List<FluidStack>> getInputs() {
        FluidStack inputs = this.inputstack;
        ArrayList<FluidStack> stack = new ArrayList<FluidStack>();
        stack.add(inputs);
        return Collections.singletonList(stack);
    }

    public List<FluidStack> getOutputs() {
        return new ArrayList<FluidStack>(Collections.singleton(this.outputstack));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, this.getInputs());
        ingredients.setOutputs(VanillaTypes.FLUID, this.getOutputs());
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78279_b(Localization.translate("cost.name") + " " + ModUtils.getString(5.0) + " QE", 10, 65, recipeWidth - 10, 0x404040);
    }
}

