/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.cokeoven;

import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CokeOvenHandler {
    private static final List<CokeOvenHandler> recipes = new ArrayList<CokeOvenHandler>();
    private final ItemStack stack;
    private final FluidStack output;

    public CokeOvenHandler(ItemStack stack, FluidStack output) {
        this.stack = stack;
        this.output = output;
    }

    public static List<CokeOvenHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CokeOvenHandler.initRecipes();
        }
        return recipes;
    }

    public static CokeOvenHandler addRecipe(ItemStack stack, FluidStack output) {
        CokeOvenHandler recipe = new CokeOvenHandler(stack, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CokeOvenHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        Iterator<CokeOvenHandler> iterator = recipes.iterator();
        if (iterator.hasNext()) {
            CokeOvenHandler recipe = iterator.next();
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        CokeOvenHandler.addRecipe(new ItemStack(Items.field_151044_h), new FluidStack(FluidName.fluidcreosote.getInstance(), 250));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

