/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.colonial_resource;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.DataItem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SpaceColonyHandler {
    private static final List<SpaceColonyHandler> recipes = new ArrayList<SpaceColonyHandler>();
    final IBody body;
    private final List<ItemStack> input;
    List<FluidStack> output;

    public SpaceColonyHandler(IBody body, List<ItemStack> input, List<FluidStack> output) {
        this.body = body;
        this.input = input;
        this.output = output;
    }

    public static List<SpaceColonyHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SpaceColonyHandler.initRecipes();
        }
        return recipes;
    }

    public static SpaceColonyHandler addRecipe(IBody body, List<ItemStack> input, List<FluidStack> output) {
        SpaceColonyHandler recipe = new SpaceColonyHandler(body, input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (IBody body : SpaceNet.instance.getBodyList()) {
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<FluidStack> fluidStacks = new LinkedList<FluidStack>();
            List<DataItem<FluidStack>> resourceFluid = SpaceNet.instance.getColonieNet().getFluidsFromBody(body);
            List<DataItem<ItemStack>> resourceStack = SpaceNet.instance.getColonieNet().getItemsFromBody(body);
            if (!(resourceFluid != null && !resourceFluid.isEmpty() || resourceStack != null && !resourceStack.isEmpty())) continue;
            for (DataItem<ItemStack> dataItem : resourceStack) {
                stacks.add(dataItem.getElement());
            }
            for (DataItem<ItemStack> dataItem : resourceFluid) {
                fluidStacks.add((FluidStack)dataItem.getElement());
            }
            SpaceColonyHandler.addRecipe(body, stacks, fluidStacks);
        }
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public List<FluidStack> getOutput() {
        return this.output;
    }
}

