/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.crops;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.integration.jei.crops.CropWrapper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CropCategory
extends Gui
implements IRecipeCategory<CropWrapper> {
    private final IDrawableStatic bg;

    public CropCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/common3.png"), 3, 3, 140, 140);
    }

    @Nonnull
    public String getUid() {
        return "iu.crop1";
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate("crop.jei1");
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
    }

    public void setRecipe(IRecipeLayout layout, CropWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        List<ItemStack> list = Arrays.asList(recipes.getInputs(), new ItemStack((Block)IUItem.crop), recipes.getOutput().getSoil().getStack());
        for (int i = 0; i < list.size(); ++i) {
            int yDisplayPosition1 = 75 + (20 - list.size()) * i - list.size() * 16;
            isg.init(i, true, 39, yDisplayPosition1);
            isg.set(i, list.get(i));
        }
        isg.init(list.size(), false, 85, 44);
        isg.set(list.size(), recipes.getOutputs());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guivein.png");
    }
}

