/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.crops;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.agriculture.ICrop;
import com.denfop.integration.jei.crops.CropCrossoverHandler;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CropCrossoverWrapper
implements IRecipeWrapper {
    public final ICrop output;
    public final List<ICrop> inputs;

    public CropCrossoverWrapper(CropCrossoverHandler container) {
        this.output = container.output;
        this.inputs = container.inputs;
    }

    public ItemStack getOutputs() {
        ItemStack stack = new ItemStack((Item)IUItem.crops);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74768_a("crop_id", this.output.getId());
        return stack;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.getOutputs());
        ingredients.setInputs(VanillaTypes.ITEM, this.getInputs());
    }

    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        this.inputs.forEach(crop -> {
            ItemStack stack = new ItemStack((Item)IUItem.crops);
            NBTTagCompound nbt = ModUtils.nbt(stack);
            nbt.func_74768_a("crop_id", crop.getId());
            itemStackList.add(stack);
        });
        return itemStackList;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b("+", 45, 48, 0x404040);
        minecraft.field_71466_p.func_78276_b("->", 65, 48, 0x404040);
        minecraft.field_71466_p.func_78279_b(Localization.translate("iu.cop.crossing"), 15, 78, recipeWidth - 5, 0x404040);
    }
}

