/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.crystal_charge;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class CrystalChargerHandler {
    private static final List<CrystalChargerHandler> recipes = new ArrayList<CrystalChargerHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public CrystalChargerHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<CrystalChargerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CrystalChargerHandler.initRecipes();
        }
        return recipes;
    }

    public static CrystalChargerHandler addRecipe(ItemStack input, ItemStack output) {
        CrystalChargerHandler recipe = new CrystalChargerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CrystalChargerHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (CrystalChargerHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("charger")) {
            CrystalChargerHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77969_a(this.input);
    }
}

