/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.cyclotron;

import com.denfop.Localization;
import com.denfop.integration.jei.cyclotron.CyclotronHandler;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CyclotronWrapper
implements IRecipeWrapper {
    private final ItemStack inputstack;
    private final ItemStack outputstack;
    private final int percent;

    public CyclotronWrapper(CyclotronHandler container) {
        this.inputstack = container.getInput();
        this.percent = container.getPercent();
        this.outputstack = container.getOutput();
    }

    public ItemStack getInput() {
        return this.inputstack;
    }

    public int getPercent() {
        return this.percent;
    }

    public List<List<ItemStack>> getInputs() {
        ItemStack inputs = this.inputstack;
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        if (OreDictionary.getOreIDs((ItemStack)inputs).length > 0) {
            int id = OreDictionary.getOreIDs((ItemStack)inputs)[0];
            stack.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        } else {
            stack.add(inputs);
        }
        return inputs.func_190926_b() ? Collections.emptyList() : Collections.singletonList(stack);
    }

    public List<ItemStack> getOutputs() {
        return new ArrayList<ItemStack>(Collections.singleton(this.outputstack));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.getInputs());
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs());
    }

    public ItemStack getOutput() {
        return this.outputstack;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78276_b(Localization.translate("chance") + this.getPercent() + "%", 50, 54, ModUtils.convertRGBcolorToInt(0, 0, 0));
    }
}

