/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gas_turbine;

import com.denfop.tiles.gasturbine.TileEntityGasTurbineController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GasTurbineHandler {
    private static final List<GasTurbineHandler> recipes = new ArrayList<GasTurbineHandler>();
    private final FluidStack input2;
    private final double input;

    public GasTurbineHandler(double input, FluidStack input2) {
        this.input = input;
        this.input2 = input2;
    }

    public static List<GasTurbineHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GasTurbineHandler.initRecipes();
        }
        return recipes;
    }

    public static GasTurbineHandler addRecipe(double input, FluidStack input2) {
        GasTurbineHandler recipe = new GasTurbineHandler(input, input2);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static GasTurbineHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        Iterator<GasTurbineHandler> iterator = recipes.iterator();
        if (iterator.hasNext()) {
            GasTurbineHandler recipe = iterator.next();
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (Map.Entry<Fluid, Integer> integerMap : TileEntityGasTurbineController.gasMapValue.entrySet()) {
            GasTurbineHandler.addRecipe(integerMap.getValue() * 1000, new FluidStack(integerMap.getKey(), 1000));
        }
    }

    public double getEnergy() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.input2;
    }
}

