/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gas_well;

import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.Fluid;

public class GasWellHandler {
    private static final List<GasWellHandler> recipes = new ArrayList<GasWellHandler>();
    public final Fluid input;
    public final String output;

    public GasWellHandler(Fluid input, String output) {
        this.input = input;
        this.output = output;
    }

    public static List<GasWellHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GasWellHandler.initRecipes();
        }
        return recipes;
    }

    public static GasWellHandler addRecipe(Fluid input, String output) {
        GasWellHandler recipe = new GasWellHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        GasWellHandler.addRecipe(FluidName.fluidgas.getInstance(), Localization.translate("quarry.guide.gas_well7"));
        GasWellHandler.addRecipe(FluidName.fluidiodine.getInstance(), Localization.translate("quarry.guide.gas_well7"));
        GasWellHandler.addRecipe(FluidName.fluidfluor.getInstance(), Localization.translate("quarry.guide.gas_well7"));
        GasWellHandler.addRecipe(FluidName.fluidbromine.getInstance(), Localization.translate("quarry.guide.gas_well7"));
        GasWellHandler.addRecipe(FluidName.fluidchlorum.getInstance(), Localization.translate("quarry.guide.gas_well7"));
    }
}

