/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gassensor;

import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.Fluid;

public class GasSensorHandler {
    private static final List<GasSensorHandler> recipes = new ArrayList<GasSensorHandler>();
    public final Fluid input;
    public final String output;

    public GasSensorHandler(Fluid input, String output) {
        this.input = input;
        this.output = output;
    }

    public static List<GasSensorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GasSensorHandler.initRecipes();
        }
        return recipes;
    }

    public static GasSensorHandler addRecipe(Fluid input, String output) {
        GasSensorHandler recipe = new GasSensorHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        GasSensorHandler.addRecipe(FluidName.fluidgas.getInstance(), Localization.translate("iu.gas_find.info"));
        GasSensorHandler.addRecipe(FluidName.fluidiodine.getInstance(), Localization.translate("iu.iodine_find.info"));
        GasSensorHandler.addRecipe(FluidName.fluidfluor.getInstance(), Localization.translate("iu.iodine_find.info"));
        GasSensorHandler.addRecipe(FluidName.fluidbromine.getInstance(), Localization.translate("iu.bromine_find.info"));
        GasSensorHandler.addRecipe(FluidName.fluidchlorum.getInstance(), Localization.translate("iu.chlorine_find.info"));
    }
}

