/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.genstone;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine;
import com.denfop.integration.jei.genstone.GenStoneRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GenStoneCategory
extends Gui
implements IRecipeCategory<GenStoneRecipeWrapper> {
    private final IDrawableStatic bg;
    private int energy = 0;

    public GenStoneCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GuiGenStone.png"), 3, 3, 140, 75);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine.gen_stone.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.machines, 1, 7).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(Minecraft mc) {
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(6, 47 - energylevel, 176, 14 - energylevel, 14, energylevel);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        GlStateManager.func_179140_f();
        GlStateManager.func_179126_j();
        this.field_73735_i = 100.0f;
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_175599_af().func_180450_b(new ItemStack(Blocks.field_150347_e), 61, 25);
        GL11.glDisable((int)2896);
        GlStateManager.func_179145_e();
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    public void setRecipe(IRecipeLayout layout, GenStoneRecipeWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 34, 18);
        isg.set(0, recipes.getInput());
        isg.init(1, true, 34, 46);
        isg.set(1, recipes.getInput1());
        isg.init(2, false, 86, 5);
        isg.set(2, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GuiGenStone.png");
    }
}

