/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.geothermal;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.integration.jei.geothermal.GeoThermalHandler;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GeoThermalWrapper
implements IRecipeWrapper {
    private final FluidStack outputstack;
    private final FluidStack inputstack;

    public GeoThermalWrapper(GeoThermalHandler container) {
        this.inputstack = container.getInput();
        this.outputstack = container.getOutput();
    }

    public FluidStack getInputstack() {
        return this.inputstack;
    }

    public FluidStack getOutputstack() {
        return this.outputstack;
    }

    public List<List<FluidStack>> getInputs() {
        FluidStack inputs = this.inputstack;
        ArrayList<FluidStack> stack = new ArrayList<FluidStack>();
        stack.add(inputs);
        return Collections.singletonList(stack);
    }

    public List<FluidStack> getOutputs() {
        return new ArrayList<FluidStack>(Collections.singleton(this.outputstack));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, this.getInputs());
        ingredients.setOutputs(VanillaTypes.FLUID, this.getOutputs());
        ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(new ItemStack((Item)IUItem.crafting_elements, 1, 457), new ItemStack((Item)IUItem.crafting_elements, 1, 461), new ItemStack((Item)IUItem.crafting_elements, 1, 462), new ItemStack((Item)IUItem.crafting_elements, 1, 463)));
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78279_b(Localization.translate("cost.name") + " " + ModUtils.getString(10.0) + " QE", 10, 65, recipeWidth - 10, 0x404040);
        int y = 80;
        int x = 35;
        for (int i = 0; i < 4; ++i) {
            double percent = 2.0;
            if (i > 0) {
                percent = 0.5;
            }
            minecraft.field_71466_p.func_78279_b("-> " + percent + "%", x, y, recipeWidth - x, 0x404040);
            y += 16;
        }
    }
}

