/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.imprefiner;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ImpRefinerHandler {
    private static final List<ImpRefinerHandler> recipes = new ArrayList<ImpRefinerHandler>();
    private final FluidStack output1;
    private final FluidStack input;
    private final FluidStack output;

    public ImpRefinerHandler(FluidStack input, FluidStack output, FluidStack output1) {
        this.input = input;
        this.output1 = output1;
        this.output = output;
    }

    public static List<ImpRefinerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ImpRefinerHandler.initRecipes();
        }
        return recipes;
    }

    public static ImpRefinerHandler addRecipe(FluidStack input, FluidStack output, FluidStack output1) {
        ImpRefinerHandler recipe = new ImpRefinerHandler(input, output, output1);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ImpRefinerHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe machineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("imp_oil_refiner")) {
            FluidStack fluidStack = machineRecipe.getInput().getInputs().get(0);
            FluidStack fluidStack1 = machineRecipe.getOutput_fluid().get(0);
            FluidStack fluidStack2 = machineRecipe.getOutput_fluid().get(1);
            double m = 1000.0 / (double)fluidStack.amount;
            ImpRefinerHandler.addRecipe(new FluidStack(fluidStack.getFluid(), (int)(m * (double)fluidStack.amount)), new FluidStack(fluidStack1.getFluid(), (int)(m * (double)fluidStack1.amount)), new FluidStack(fluidStack2.getFluid(), (int)(m * (double)fluidStack2.amount)));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getOutput1() {
        return this.output1;
    }
}

