/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.itemdividerfluid;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ItemDividerFluidHandler {
    private static final List<ItemDividerFluidHandler> recipes = new ArrayList<ItemDividerFluidHandler>();
    private final ItemStack input;
    private final FluidStack output1;
    private final FluidStack output;

    public ItemDividerFluidHandler(ItemStack input, FluidStack output, FluidStack output1) {
        this.input = input;
        this.output1 = output1;
        this.output = output;
    }

    public static List<ItemDividerFluidHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ItemDividerFluidHandler.initRecipes();
        }
        return recipes;
    }

    public static ItemDividerFluidHandler addRecipe(ItemStack input, FluidStack output, FluidStack output1) {
        ItemDividerFluidHandler recipe = new ItemDividerFluidHandler(input, output, output1);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ItemDividerFluidHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe machineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("item_divider_fluid")) {
            ItemStack itemStack = machineRecipe.getInput().getStack().getInputs().get(0);
            FluidStack fluidStack1 = machineRecipe.getOutput_fluid().get(0);
            FluidStack fluidStack2 = machineRecipe.getOutput_fluid().get(1);
            ItemDividerFluidHandler.addRecipe(itemStack, fluidStack1, fluidStack2);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getOutput1() {
        return this.output1;
    }
}

