/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.microchip;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine;
import com.denfop.integration.jei.microchip.MicrochipRecipeWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MicrochipCategory
extends Gui
implements IRecipeCategory<MicrochipRecipeWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public MicrochipCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GUICirsuit.png"), 3, 3, 140, 77);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine.generator_microchip.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.machines, 1, 6).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        double energylevel = Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        double xScale = 24.0 * (double)this.progress / 100.0;
        double xScale1 = 10.0f * (float)this.progress / 100.0f;
        double xScale2 = 19.0f * (float)this.progress / 100.0f;
        if (xScale > 24.0) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(25, 9, 176, 34, (int)(xScale + 1.0), 32);
        this.func_73729_b(57, 13, 176, 65, (int)(xScale1 + 1.0), 21);
        this.func_73729_b(86, 19, 176, 86, (int)(xScale2 + 1.0), 7);
        this.func_73729_b(2, 73 - (int)energylevel, 176, 14 - (int)energylevel, 14, (int)energylevel);
    }

    public void setRecipe(IRecipeLayout layout, MicrochipRecipeWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 6, 5);
        isg.set(0, recipes.getInput());
        isg.init(1, true, 6, 26);
        isg.set(1, recipes.getInput1());
        isg.init(2, true, 39, 5);
        isg.set(2, recipes.getInput2());
        isg.init(3, true, 39, 25);
        isg.set(3, recipes.getInput3());
        isg.init(4, true, 67, 15);
        isg.set(4, recipes.getInput4());
        isg.init(5, false, 108, 15);
        isg.set(5, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GUICirsuit.png");
    }
}

