/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.mini_smeltery;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MiniSmelteryHandler {
    private static final List<MiniSmelteryHandler> recipes = new ArrayList<MiniSmelteryHandler>();
    private final FluidStack input;
    private final ItemStack output;

    public MiniSmelteryHandler(FluidStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<MiniSmelteryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            MiniSmelteryHandler.initRecipes();
        }
        return recipes;
    }

    public static MiniSmelteryHandler addRecipe(FluidStack input, ItemStack output) {
        MiniSmelteryHandler recipe = new MiniSmelteryHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe container : Recipes.recipes.getRecipeFluid().getRecipeList("mini_smeltery")) {
            MiniSmelteryHandler.addRecipe(container.input.getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

