/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.multiblock;

import com.denfop.Localization;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.integration.jei.multiblock.MultiBlockHandler;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class MultiBlockWrapper
implements IRecipeWrapper {
    public final MultiBlockStructure structure;
    public final String name;

    public MultiBlockWrapper(MultiBlockHandler container) {
        this.structure = container.getStructure();
        this.name = container.getName();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.structure.itemStackList);
    }

    public void renderTextCentered(@Nonnull Minecraft minecraft, String text, int xCenter, int y, int maxWidth, int color) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        List lines = fontRenderer.func_78271_c(text, maxWidth);
        int lineHeight = fontRenderer.field_78288_b;
        int totalHeight = lines.size() * lineHeight;
        int startY = y - totalHeight / 2;
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            int lineWidth = fontRenderer.func_78256_a(line);
            int x = xCenter - lineWidth / 2;
            fontRenderer.func_78276_b(line, x, startY + i * lineHeight, color);
        }
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String name1 = Localization.translate("multiblock.jei1");
        int xCenter = recipeWidth / 2;
        int maxWidth = recipeWidth - 20;
        int color = 0x404040;
        this.renderTextCentered(minecraft, name1, xCenter, 25, maxWidth, color);
        int y = 2;
        this.renderTextCentered(minecraft, Localization.translate("multiblock.jei2"), xCenter, 57 + y * 25, maxWidth, color);
        this.renderTextCentered(minecraft, Localization.translate("multiblock.jei3"), xCenter, 10 + y * 25 + 90, maxWidth, color);
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }
}

