/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.mutatron;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MutatronHandler {
    private static final List<MutatronHandler> recipes = new ArrayList<MutatronHandler>();
    private final FluidStack output1;
    private final FluidStack input;
    private final FluidStack output;

    public MutatronHandler(FluidStack input, FluidStack output, FluidStack output1) {
        this.input = input;
        this.output1 = output1;
        this.output = output;
    }

    public static List<MutatronHandler> getRecipes() {
        if (recipes.isEmpty()) {
            MutatronHandler.initRecipes();
        }
        return recipes;
    }

    public static MutatronHandler addRecipe(FluidStack input, FluidStack output, FluidStack output1) {
        MutatronHandler recipe = new MutatronHandler(input, output, output1);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static MutatronHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe machineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("mutatron")) {
            FluidStack fluidStack = machineRecipe.getInput().getInputs().get(0);
            FluidStack fluidStack1 = machineRecipe.getInput().getInputs().get(1);
            FluidStack fluidStack2 = machineRecipe.getOutput_fluid().get(0);
            MutatronHandler.addRecipe(fluidStack, fluidStack1, fluidStack2);
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getOutput1() {
        return this.output1;
    }
}

