/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.pellets;

import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.integration.jei.JEICompat;
import com.denfop.integration.jei.pellets.PelletsWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public class PelletsCategory
extends Gui
implements IRecipeCategory<PelletsWrapper> {
    private final IDrawableStatic bg;

    public PelletsCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guipallet.png"), 5, 3, 165, 77);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine3.pallet_generator.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(JEICompat.getBlockStack(BlockBaseMachine3.pallet_generator).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(Minecraft mc) {
        mc.func_110434_K().func_110577_a(this.getTexture());
        for (int x = 30; x <= 68; x += 18) {
            for (int y = 18; y <= 36; y += 18) {
                this.func_73729_b(0 + x, 0 + y, 179, 30, 18, 18);
            }
        }
    }

    public void setRecipe(IRecipeLayout layout, PelletsWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        for (int i = 0; i < recipes.getCol(); ++i) {
            isg.init(i, true, 30 + i % 3 * 18, 18 + i / 3 * 18);
            isg.set(i, recipes.getInput2());
        }
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guipallet.png");
    }
}

