/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.pellets;

import com.denfop.IUItem;
import com.denfop.tiles.mechanism.TileEntityPalletGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PelletsHandler {
    private static final List<PelletsHandler> recipes = new ArrayList<PelletsHandler>();
    private final ItemStack input2;
    private final double input;
    private final int col;

    public PelletsHandler(double input, ItemStack input2, int col) {
        this.input = input;
        this.input2 = input2;
        this.col = col;
    }

    public static List<PelletsHandler> getRecipes() {
        if (recipes.isEmpty()) {
            PelletsHandler.initRecipes();
        }
        return recipes;
    }

    public static PelletsHandler addRecipe(double input, ItemStack input2, int col) {
        PelletsHandler recipe = new PelletsHandler(input, input2, col);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static PelletsHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        Iterator<PelletsHandler> iterator = recipes.iterator();
        if (iterator.hasNext()) {
            PelletsHandler recipe = iterator.next();
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        double coef1;
        double coef;
        ItemStack stack;
        int j;
        int i;
        for (i = 0; i < 13; ++i) {
            for (j = 0; j < 6; ++j) {
                stack = new ItemStack((Item)IUItem.pellets, 1, i);
                coef = 1.0;
                for (Map.Entry<ItemStack, Double> entry : TileEntityPalletGenerator.integerMap.entrySet()) {
                    if (!entry.getKey().func_77969_a(stack)) continue;
                    coef = entry.getValue();
                }
                coef1 = Math.pow(coef, j + 1);
                PelletsHandler.addRecipe(coef1, stack, j + 1);
            }
        }
        for (i = 8; i < 10; ++i) {
            for (j = 0; j < 6; ++j) {
                stack = new ItemStack((Item)IUItem.nuclear_res, 1, i);
                coef = 1.0;
                for (Map.Entry<ItemStack, Double> entry : TileEntityPalletGenerator.integerMap.entrySet()) {
                    if (!entry.getKey().func_77969_a(stack)) continue;
                    coef = entry.getValue();
                }
                coef1 = Math.pow(coef, j + 1);
                PelletsHandler.addRecipe(coef1, stack, j + 1);
            }
        }
    }

    public double getInput() {
        return this.input;
    }

    public int getCol() {
        return this.col;
    }

    public ItemStack getInput2() {
        return this.input2;
    }
}

