/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.polymerizer;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class PolymerizerHandler {
    private static final List<PolymerizerHandler> recipes = new ArrayList<PolymerizerHandler>();
    private final FluidStack input;
    private final FluidStack output;

    public PolymerizerHandler(FluidStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<PolymerizerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            PolymerizerHandler.initRecipes();
        }
        return recipes;
    }

    public static PolymerizerHandler addRecipe(FluidStack input, FluidStack output) {
        PolymerizerHandler recipe = new PolymerizerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe container : Recipes.recipes.getRecipeFluid().getRecipeList("polymerizer")) {
            PolymerizerHandler.addRecipe(container.input.getInputs().get(0), container.getOutput_fluid().get(0));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

