/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.primalfluidintergrator;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class PrimalFluidIntegratorHandler {
    private static final List<PrimalFluidIntegratorHandler> recipes = new ArrayList<PrimalFluidIntegratorHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final FluidStack inputFluid;
    private final FluidStack outputFluid;

    public PrimalFluidIntegratorHandler(ItemStack input, ItemStack output, FluidStack inputFluid, FluidStack outputFluid) {
        this.input = input;
        this.output = output;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
    }

    public static List<PrimalFluidIntegratorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            PrimalFluidIntegratorHandler.initRecipes();
        }
        return recipes;
    }

    public static PrimalFluidIntegratorHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        List<BaseFluidMachineRecipe> list = Recipes.recipes.getRecipeFluid().getRecipeList("primal_fluid_integrator");
        List<BaseMachineRecipe> list1 = Recipes.recipes.getRecipeList("primal_fluid_integrator");
        for (int i = 0; i < list1.size(); ++i) {
            BaseFluidMachineRecipe baseFluidMachineRecipe = list.get(i);
            BaseMachineRecipe baseMachineRecipe = list1.get(i);
            ItemStack input = baseMachineRecipe.input.getInputs().get(0).getInputs().get(0);
            ItemStack output = baseMachineRecipe.getOutput().items.get(0);
            FluidStack inputFluid = baseMachineRecipe.input.getFluid();
            FluidStack outputFluid = baseFluidMachineRecipe.output_fluid.get(0);
            PrimalFluidIntegratorHandler.addRecipe(input, output, inputFluid, outputFluid);
        }
    }

    private static PrimalFluidIntegratorHandler addRecipe(ItemStack input, ItemStack output, FluidStack inputFluid, FluidStack outputFluid) {
        PrimalFluidIntegratorHandler recipe = new PrimalFluidIntegratorHandler(input, output, inputFluid, outputFluid);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }
}

