/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.rocketassembler;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RocketAssemblerHandler {
    private static final List<RocketAssemblerHandler> recipes = new ArrayList<RocketAssemblerHandler>();
    private final List<ItemStack> input;
    ItemStack output;

    public RocketAssemblerHandler(List<ItemStack> input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<RocketAssemblerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RocketAssemblerHandler.initRecipes();
        }
        return recipes;
    }

    public static RocketAssemblerHandler addRecipe(List<ItemStack> input, ItemStack output) {
        RocketAssemblerHandler recipe = new RocketAssemblerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("rocketassembler")) {
            RocketAssemblerHandler.addRecipe(container.input.getStackInputs(), container.getOutput().items.get(0));
        }
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }
}

