/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.rubbertree;

import com.denfop.integration.jei.rubbertree.RubberTreeStructure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class RubberTreeHandler {
    private static final List<RubberTreeHandler> recipes = new ArrayList<RubberTreeHandler>();
    Map<BlockPos, IBlockState> map;

    public RubberTreeHandler(Map<BlockPos, IBlockState> map) {
        this.map = map;
    }

    public static List<RubberTreeHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RubberTreeHandler.initRecipes();
        }
        return recipes;
    }

    public static RubberTreeHandler addRecipe(Map<BlockPos, IBlockState> map) {
        RubberTreeHandler recipe = new RubberTreeHandler(map);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static RubberTreeHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        Iterator<RubberTreeHandler> iterator = recipes.iterator();
        if (iterator.hasNext()) {
            RubberTreeHandler recipe = iterator.next();
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        RubberTreeStructure.init();
        for (Map<BlockPos, IBlockState> container : RubberTreeStructure.rubberTreesList) {
            RubberTreeHandler.addRecipe(container);
        }
    }

    public Map<BlockPos, IBlockState> getMap() {
        return this.map;
    }
}

