/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.rubbertree;

import com.denfop.IUItem;
import com.denfop.blocks.BlockRubWood;
import com.denfop.blocks.BlockSwampRubWood;
import com.denfop.blocks.BlockTropicalRubWood;
import com.denfop.blocks.IULeaves;
import com.denfop.world.WorldBaseGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class RubberTreeStructure {
    public static List<Map<BlockPos, IBlockState>> rubberTreesList = new ArrayList<Map<BlockPos, IBlockState>>();

    public static void init() {
        RubberTreeStructure.initFirstRubber();
        RubberTreeStructure.initTwoRubber();
        RubberTreeStructure.initThreeRubber();
        RubberTreeStructure.initFourRubber();
    }

    private static void initFourRubber() {
        BlockPos position = BlockPos.field_177992_a;
        Random rand = new Random();
        IBlockState leaves = IUItem.leaves.func_176223_P().func_177226_a(IULeaves.typeProperty, (Comparable)((Object)IULeaves.LeavesType.rubber));
        HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
        int max = 6;
        int treeholechance = 90;
        BlockTropicalRubWood woodBlock = IUItem.tropicalRubWood;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                BlockPos upN = position.func_177977_b().func_177982_a(x, 0, z);
                BlockTropicalRubWood.RubberWoodState rubberWoodState = x == 1 || x == -1 ? BlockTropicalRubWood.RubberWoodState.plain_x : BlockTropicalRubWood.RubberWoodState.plain_z;
                if (stateMap.containsKey(upN)) {
                    stateMap.replace(upN, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    continue;
                }
                stateMap.put(upN, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
            }
        }
        for (int j2 = 0; j2 < max; ++j2) {
            BlockPos upN = position.func_177981_b(j2);
            if (j2 == max - 1) {
                BlockPos upN2;
                int zz;
                int xx;
                BlockPos upN1;
                for (int x = -2; x < 3; ++x) {
                    for (int z = -2; z < 3; ++z) {
                        int j;
                        int yy;
                        int zz2;
                        BlockPos upN22;
                        int xx2;
                        if (x == 0 && z == 0 || z != 0 && x != 0) continue;
                        upN1 = upN.func_177982_a(x, 0, z);
                        BlockTropicalRubWood.RubberWoodState rubberWoodState = x != 0 ? BlockTropicalRubWood.RubberWoodState.plain_x : BlockTropicalRubWood.RubberWoodState.plain_z;
                        if (stateMap.containsKey(upN1)) {
                            stateMap.replace(upN1, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        } else {
                            stateMap.put(upN1, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        }
                        upN1 = upN1.func_177984_a();
                        if (x <= -1) {
                            upN1 = upN1.func_177982_a(-1, 0, 0);
                        } else if (z <= -1) {
                            upN1 = upN1.func_177982_a(0, 0, -1);
                        } else if (x >= 1) {
                            upN1 = upN1.func_177982_a(1, 0, 0);
                        } else if (z >= 1) {
                            upN1 = upN1.func_177982_a(0, 0, 1);
                        }
                        if (stateMap.containsKey(upN1)) {
                            stateMap.replace(upN1, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        } else {
                            stateMap.put(upN1, woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        }
                        for (xx2 = -1; xx2 < 2; ++xx2) {
                            for (int zz3 = -1; zz3 < 2; ++zz3) {
                                if (xx2 == 0 && zz3 == 0 || xx2 == -1 && zz3 == -1 || xx2 == 1 && zz3 == 1 || xx2 == 1 && zz3 == -1 || xx2 == -1 && zz3 == 1) continue;
                                upN22 = upN1.func_177982_a(xx2, 0, zz3);
                                if (stateMap.containsKey(upN22)) {
                                    stateMap.replace(upN22, leaves);
                                    continue;
                                }
                                stateMap.put(upN22, leaves);
                            }
                        }
                        if (stateMap.containsKey(upN1 = upN1.func_177984_a())) {
                            stateMap.replace(upN1, leaves);
                        } else {
                            stateMap.put(upN1, leaves);
                        }
                        upN1 = upN1.func_177977_b();
                        if (x == -2) {
                            for (zz2 = -1; zz2 < 2; ++zz2) {
                                for (yy = -1; yy < 2; ++yy) {
                                    upN22 = upN1.func_177982_a(0, yy, zz2);
                                    if (stateMap.containsKey(upN22)) {
                                        stateMap.replace(upN22, leaves);
                                        continue;
                                    }
                                    stateMap.put(upN22, leaves);
                                }
                            }
                            upN1 = upN1.func_177982_a(-1, 0, 0);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN23 = upN1.func_177982_a(0, j, 0);
                                if (stateMap.containsKey(upN23)) {
                                    stateMap.replace(upN23, leaves);
                                } else {
                                    stateMap.put(upN23, leaves);
                                }
                                if (j != 0) continue;
                                for (int zz4 = -1; zz4 < 2; ++zz4) {
                                    for (int yy2 = -1; yy2 < 2; ++yy2) {
                                        if (zz4 == 0 && yy2 == 0 || zz4 == -1 && yy2 == -1 || zz4 == 1 && yy2 == 1 || zz4 == 1 && yy2 == -1 || zz4 == -1 && yy2 == 1) continue;
                                        BlockPos upN3 = upN1.func_177982_a(0, yy2, zz4);
                                        if (stateMap.containsKey(upN3)) {
                                            stateMap.replace(upN3, leaves);
                                            continue;
                                        }
                                        stateMap.put(upN3, leaves);
                                    }
                                }
                            }
                            continue;
                        }
                        if (z == -2) {
                            for (xx2 = -1; xx2 < 2; ++xx2) {
                                for (yy = -1; yy < 2; ++yy) {
                                    upN22 = upN1.func_177982_a(xx2, yy, 0);
                                    if (stateMap.containsKey(upN22)) {
                                        stateMap.replace(upN22, leaves);
                                        continue;
                                    }
                                    stateMap.put(upN22, leaves);
                                }
                            }
                            upN1 = upN1.func_177982_a(0, 0, -1);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN24 = upN1.func_177982_a(0, j, 0);
                                if (stateMap.containsKey(upN24)) {
                                    stateMap.replace(upN24, leaves);
                                    continue;
                                }
                                stateMap.put(upN24, leaves);
                            }
                            continue;
                        }
                        if (x == 2) {
                            for (zz2 = -1; zz2 < 2; ++zz2) {
                                for (yy = -1; yy < 2; ++yy) {
                                    upN22 = upN1.func_177982_a(0, yy, zz2);
                                    if (stateMap.containsKey(upN22)) {
                                        stateMap.replace(upN22, leaves);
                                        continue;
                                    }
                                    stateMap.put(upN22, leaves);
                                }
                            }
                            upN1 = upN1.func_177982_a(1, 0, 0);
                            for (j = 1; j > -4; --j) {
                                BlockPos upN25 = upN1.func_177982_a(0, j, 0);
                                if (stateMap.containsKey(upN25)) {
                                    stateMap.replace(upN25, leaves);
                                    continue;
                                }
                                stateMap.put(upN25, leaves);
                            }
                            continue;
                        }
                        if (z != 2) continue;
                        for (xx2 = -1; xx2 < 2; ++xx2) {
                            for (yy = -1; yy < 2; ++yy) {
                                upN22 = upN1.func_177982_a(xx2, yy, 0);
                                if (stateMap.containsKey(upN22)) {
                                    stateMap.replace(upN22, leaves);
                                    continue;
                                }
                                stateMap.put(upN22, leaves);
                            }
                        }
                        upN1 = upN1.func_177982_a(0, 0, 1);
                        for (j = 1; j > -4; --j) {
                            BlockPos upN26 = upN1.func_177982_a(0, j, 0);
                            if (stateMap.containsKey(upN26)) {
                                stateMap.replace(upN26, leaves);
                                continue;
                            }
                            stateMap.put(upN26, leaves);
                        }
                    }
                }
                upN1 = upN.func_177984_a();
                for (xx = -1; xx < 2; ++xx) {
                    for (zz = -1; zz < 2; ++zz) {
                        if (!(xx == -1 && zz == -1 || xx == 1 && zz == 1 || xx == 1 && zz == -1) && (xx != -1 || zz != 1)) continue;
                        upN2 = upN1.func_177982_a(xx, 0, zz);
                        if (stateMap.containsKey(upN2)) {
                            stateMap.replace(upN2, leaves);
                            continue;
                        }
                        stateMap.put(upN2, leaves);
                    }
                }
                if (stateMap.containsKey(upN1)) {
                    stateMap.replace(upN1, leaves);
                } else {
                    stateMap.put(upN1, leaves);
                }
                upN1 = upN.func_177984_a().func_177984_a();
                for (xx = -1; xx < 2; ++xx) {
                    for (zz = -1; zz < 2; ++zz) {
                        if (xx == -1 && zz == -1 || xx == 1 && zz == 1 || xx == 1 && zz == -1 || xx == -1 && zz == 1) continue;
                        upN2 = upN1.func_177982_a(xx, 0, zz);
                        if (stateMap.containsKey(upN2)) {
                            stateMap.replace(upN2, leaves);
                            continue;
                        }
                        stateMap.put(upN2, leaves);
                    }
                }
            }
            if (rand.nextInt(100) <= treeholechance && j2 < max - 1) {
                treeholechance -= 10;
                if (stateMap.containsKey(position.func_177981_b(j2))) {
                    stateMap.replace(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                    continue;
                }
                stateMap.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                continue;
            }
            if (stateMap.containsKey(position.func_177981_b(j2))) {
                stateMap.replace(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.plain_y)));
                continue;
            }
            stateMap.put(position.func_177981_b(j2), woodBlock.func_176223_P().func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.plain_y)));
        }
        rubberTreesList.add(stateMap);
    }

    private static void initThreeRubber() {
        BlockPos position = BlockPos.field_177992_a;
        Random rand = new Random();
        IBlockState leaves = IUItem.leaves.func_176223_P().func_177226_a(IULeaves.typeProperty, (Comparable)((Object)IULeaves.LeavesType.rubber));
        HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
        int treeholechance = 60;
        BlockSwampRubWood woodBlock = IUItem.swampRubWood;
        int max = 5;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                BlockPos upN = position.func_177977_b().func_177982_a(x, 0, z);
                BlockSwampRubWood.RubberWoodState rubberWoodState = x == 1 || x == -1 ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                if (stateMap.containsKey(upN)) {
                    stateMap.replace(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    continue;
                }
                stateMap.put(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
            }
        }
        for (int j2 = 0; j2 < 5; ++j2) {
            int y;
            BlockPos upN = position.func_177981_b(j2);
            if (j2 < 4) {
                if (rand.nextInt(100) <= treeholechance) {
                    treeholechance -= 10;
                    if (stateMap.containsKey(upN)) {
                        stateMap.replace(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                        continue;
                    }
                    stateMap.put(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                    continue;
                }
                if (stateMap.containsKey(upN)) {
                    stateMap.replace(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                    continue;
                }
                stateMap.put(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                continue;
            }
            if (j2 != 4) continue;
            if (rand.nextInt(100) <= treeholechance) {
                treeholechance -= 10;
                if (stateMap.containsKey(upN)) {
                    stateMap.replace(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                } else {
                    stateMap.put(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                }
            } else if (stateMap.containsKey(upN)) {
                stateMap.replace(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
            } else {
                stateMap.put(upN, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
            }
            BlockPos upN1 = position.func_177981_b(j2);
            for (y = 0; y < 5; ++y) {
                int radius = 0;
                if (y < 3) {
                    radius = 3;
                }
                if (y == 3) {
                    radius = 1;
                }
                if (y == 4) {
                    radius = 0;
                }
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + z * z > radius * radius || Math.abs(x) == Math.abs(z) && Math.abs(x) == 2 || y == 2 && (Math.abs(z) == 0 && Math.abs(x) == 3 || Math.abs(z) == 3 && Math.abs(x) == 0)) continue;
                        BlockPos pos = upN1.func_177982_a(x, y, z);
                        if (stateMap.containsKey(pos)) {
                            stateMap.replace(pos, leaves);
                            continue;
                        }
                        stateMap.put(pos, leaves);
                    }
                }
            }
            upN1 = position.func_177981_b(j2).func_177977_b().func_177977_b();
            for (y = 0; y < 2; ++y) {
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        if (x == 0 && z == 0 || (y != 0 ? Math.abs(x) != Math.abs(z) : Math.abs(x) == Math.abs(z))) continue;
                        BlockPos upN2 = upN1.func_177982_a(x, y, z);
                        if (stateMap.containsKey(upN2)) {
                            stateMap.replace(upN2, leaves);
                            continue;
                        }
                        stateMap.put(upN2, leaves);
                    }
                }
            }
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    if (x == 0 && z == 0 || z != 0 && x != 0) continue;
                    upN1 = upN.func_177982_a(x, 0, z);
                    BlockSwampRubWood.RubberWoodState rubberWoodState = x != 0 ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                    if (stateMap.containsKey(upN1)) {
                        stateMap.replace(upN1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    } else {
                        stateMap.put(upN1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    }
                    upN1 = upN1.func_177977_b();
                    if (stateMap.containsKey(upN1)) {
                        stateMap.replace(upN1, leaves);
                    } else {
                        stateMap.put(upN1, leaves);
                    }
                    upN1 = upN1.func_177984_a().func_177984_a();
                    if (x == -1) {
                        upN1 = upN1.func_177982_a(-1, 0, 0);
                    } else if (z == -1) {
                        upN1 = upN1.func_177982_a(0, 0, -1);
                    } else if (x == 1) {
                        upN1 = upN1.func_177982_a(1, 0, 0);
                    } else {
                        if (z != 1) continue;
                        upN1 = upN1.func_177982_a(0, 0, 1);
                    }
                    rubberWoodState = BlockSwampRubWood.RubberWoodState.plain_y;
                    if (stateMap.containsKey(upN1)) {
                        stateMap.replace(upN1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        continue;
                    }
                    stateMap.put(upN1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                }
            }
        }
        rubberTreesList.add(stateMap);
    }

    private static void initTwoRubber() {
        BlockPos position = BlockPos.field_177992_a;
        Random rand = new Random();
        IBlockState leaves = IUItem.leaves.func_176223_P().func_177226_a(IULeaves.typeProperty, (Comparable)((Object)IULeaves.LeavesType.rubber));
        HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
        int treeholechance = 60;
        BlockSwampRubWood woodBlock = IUItem.swampRubWood;
        int max = 7;
        EnumFacing facing = null;
        for (int j2 = 0; j2 < 7; ++j2) {
            BlockPos pos1;
            BlockPos upN = position.func_177981_b(j2);
            int type = WorldBaseGen.random.nextInt(3);
            if (WorldBaseGen.random.nextInt(100) <= 50 && j2 > 1 && j2 != 6) {
                EnumFacing prevFacing;
                if (type == 0) {
                    prevFacing = facing;
                    facing = EnumFacing.values()[2 + WorldBaseGen.random.nextInt(4)];
                    while (facing == prevFacing) {
                        facing = EnumFacing.values()[2 + WorldBaseGen.random.nextInt(4)];
                    }
                    BlockPos pos12 = upN.func_177972_a(facing);
                    BlockSwampRubWood.RubberWoodState rubberWoodState = facing.func_176740_k() == EnumFacing.Axis.X ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                    if (stateMap.containsKey(pos12)) {
                        stateMap.replace(pos12, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    } else {
                        stateMap.put(pos12, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                    }
                    for (int x = -1; x < 2; ++x) {
                        for (int z = -1; z < 2; ++z) {
                            if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                            BlockPos pos2 = pos12.func_177982_a(x, 0, z);
                            if (stateMap.containsKey(pos2)) {
                                stateMap.replace(pos2, leaves);
                                continue;
                            }
                            stateMap.put(pos2, leaves);
                        }
                    }
                } else if (type == 1) {
                    int ii;
                    prevFacing = facing;
                    facing = EnumFacing.values()[2 + WorldBaseGen.random.nextInt(4)];
                    while (facing == prevFacing) {
                        facing = EnumFacing.values()[2 + WorldBaseGen.random.nextInt(4)];
                    }
                    BlockPos pos13 = upN;
                    int max1 = 2;
                    for (ii = 0; ii < max1; ++ii) {
                        pos13 = pos13.func_177972_a(facing);
                        BlockSwampRubWood.RubberWoodState rubberWoodState = facing.func_176740_k() == EnumFacing.Axis.X ? BlockSwampRubWood.RubberWoodState.plain_x : BlockSwampRubWood.RubberWoodState.plain_z;
                        if (stateMap.containsKey(pos13)) {
                            stateMap.replace(pos13, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        } else {
                            stateMap.put(pos13, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rubberWoodState)));
                        }
                        for (int x = -1; x < 2; ++x) {
                            for (int z = -1; z < 2; ++z) {
                                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                BlockPos pos2 = pos13.func_177982_a(x, 0, z);
                                if (stateMap.containsKey(pos2)) {
                                    stateMap.replace(pos2, leaves);
                                    continue;
                                }
                                stateMap.put(pos2, leaves);
                            }
                        }
                    }
                    max1 = 1;
                    for (ii = 0; ii < max1; ++ii) {
                        pos13 = pos13.func_177984_a();
                        if (rand.nextInt(100) <= treeholechance) {
                            treeholechance -= 10;
                            if (stateMap.containsKey(pos13)) {
                                stateMap.replace(pos13, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                            } else {
                                stateMap.put(pos13, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                            }
                        } else if (stateMap.containsKey(pos13)) {
                            stateMap.replace(pos13, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                        } else {
                            stateMap.put(pos13, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                        }
                        for (int x = -1; x < 2; ++x) {
                            for (int z = -1; z < 2; ++z) {
                                if (x == 0 && z == 0 || x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1) continue;
                                BlockPos pos2 = pos13.func_177982_a(x, 0, z);
                                if (stateMap.containsKey(pos2)) {
                                    stateMap.replace(pos2, leaves);
                                    continue;
                                }
                                stateMap.put(pos2, leaves);
                            }
                        }
                        BlockPos pos2 = pos13.func_177984_a();
                        if (stateMap.containsKey(pos2)) {
                            stateMap.replace(pos2, leaves);
                            continue;
                        }
                        stateMap.put(pos2, leaves);
                    }
                }
            }
            if (rand.nextInt(100) <= treeholechance) {
                treeholechance -= 10;
                pos1 = position.func_177981_b(j2);
                if (stateMap.containsKey(pos1)) {
                    stateMap.replace(pos1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                } else {
                    stateMap.put(pos1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)]))));
                }
            } else {
                pos1 = position.func_177981_b(j2);
                if (stateMap.containsKey(pos1)) {
                    stateMap.replace(pos1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                } else {
                    stateMap.put(pos1, woodBlock.func_176223_P().func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
                }
            }
            BlockPos pos = position.func_177981_b(j2);
            if (j2 >= 3) {
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        if (x == 0 && z == 0 || j2 >= 4 && (x == -1 && z == -1 || x == 1 && z == 1 || x == 1 && z == -1 || x == -1 && z == 1)) continue;
                        BlockPos pos2 = pos.func_177982_a(x, 0, z);
                        if (stateMap.containsKey(pos2)) {
                            stateMap.replace(pos2, leaves);
                            continue;
                        }
                        stateMap.put(pos2, leaves);
                    }
                }
            }
            if (j2 != 6) continue;
            BlockPos pos2 = pos.func_177984_a();
            if (stateMap.containsKey(pos2)) {
                stateMap.replace(pos2, leaves);
                continue;
            }
            stateMap.put(pos2, leaves);
        }
        rubberTreesList.add(stateMap);
    }

    private static void initFirstRubber() {
        BlockPos position = BlockPos.field_177992_a;
        Random rand = new Random();
        IBlockState leaves = IUItem.leaves.func_176223_P().func_177226_a(IULeaves.typeProperty, (Comparable)((Object)IULeaves.LeavesType.rubber));
        HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
        int i = 5;
        if (i <= 3) {
            i = 4;
        }
        for (int i2 = position.func_177956_o() - i / 2 + i; i2 <= position.func_177956_o() + i + 1 + rand.nextInt(3); ++i2) {
            int i3;
            BlockPos blockpos;
            int l1;
            int k1;
            BlockPos blockpos2;
            int[][] offsets;
            int k2 = i2 - (position.func_177956_o() + i + 1);
            int l2 = 3;
            if (i2 >= position.func_177956_o() + i) {
                l2 = 1;
            }
            if (i2 == position.func_177956_o() + i) {
                for (int[] offset : offsets = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}}) {
                    blockpos2 = new BlockPos(position.func_177958_n() + offset[0], i2, position.func_177952_p() + offset[1]);
                    if (stateMap.containsKey(blockpos2)) {
                        stateMap.replace(blockpos2, leaves);
                        continue;
                    }
                    stateMap.put(blockpos2, leaves);
                }
            }
            if (i2 == position.func_177956_o() - i / 2 + i + 1) {
                l2 = 3;
                for (int[] offset : offsets = new int[][]{{-2, 0}, {0, -2}, {2, 0}, {0, 2}}) {
                    blockpos2 = new BlockPos(position.func_177958_n() + offset[0], i2, position.func_177952_p() + offset[1]);
                    if (stateMap.containsKey(blockpos2)) {
                        stateMap.replace(blockpos2, leaves);
                        continue;
                    }
                    stateMap.put(blockpos2, leaves);
                }
            }
            if (i2 == position.func_177956_o() - i / 2 + i) {
                l2 = 4;
                if (i > 6) {
                    int i32;
                    for (i32 = position.func_177958_n() - l2 / 2; i32 <= position.func_177958_n() + l2 / 2; ++i32) {
                        int j1 = i32 - position.func_177958_n();
                        for (k1 = position.func_177952_p() - l2 / 2; k1 <= position.func_177952_p() + l2 / 2; ++k1) {
                            l1 = k1 - position.func_177952_p();
                            if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0)) continue;
                            blockpos = new BlockPos(i32, i2 - 1, k1);
                            if (stateMap.containsKey(blockpos)) {
                                stateMap.replace(blockpos, leaves);
                                continue;
                            }
                            stateMap.put(blockpos, leaves);
                        }
                    }
                    for (i32 = position.func_177958_n() - 2; i32 <= position.func_177958_n() + 2; i32 += 4) {
                        int j1 = i32 - position.func_177958_n();
                        for (k1 = position.func_177952_p() - 2; k1 <= position.func_177952_p() + 2; k1 += 4) {
                            l1 = k1 - position.func_177952_p();
                            if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0)) continue;
                            blockpos = new BlockPos(i32, i2 - 1, k1);
                            if (stateMap.containsKey(blockpos)) {
                                stateMap.replace(blockpos, leaves);
                                continue;
                            }
                            stateMap.put(blockpos, leaves);
                        }
                    }
                }
                l2 = 4;
            }
            for (i3 = position.func_177958_n() - l2 / 2; i3 <= position.func_177958_n() + l2 / 2; ++i3) {
                int j1 = i3 - position.func_177958_n();
                for (k1 = position.func_177952_p() - l2 / 2; k1 <= position.func_177952_p() + l2 / 2; ++k1) {
                    l1 = k1 - position.func_177952_p();
                    if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0)) continue;
                    blockpos = new BlockPos(i3, i2, k1);
                    if (stateMap.containsKey(blockpos)) {
                        stateMap.replace(blockpos, leaves);
                        continue;
                    }
                    stateMap.put(blockpos, leaves);
                }
            }
            if (i2 != position.func_177956_o() - i / 2 + i) continue;
            for (i3 = position.func_177958_n() - 2; i3 <= position.func_177958_n() + 2; i3 += 4) {
                int j1 = i3 - position.func_177958_n();
                for (k1 = position.func_177952_p() - 2; k1 <= position.func_177952_p() + 2; k1 += 4) {
                    l1 = k1 - position.func_177952_p();
                    if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0)) continue;
                    blockpos = new BlockPos(i3, i2, k1);
                    if (stateMap.containsKey(blockpos)) {
                        stateMap.replace(blockpos, leaves);
                        continue;
                    }
                    stateMap.put(blockpos, leaves);
                }
            }
        }
        BlockRubWood woodBlock = IUItem.rubWood;
        int treeholechance = 40;
        for (int j2 = 0; j2 < i; ++j2) {
            if (rand.nextInt(100) <= treeholechance) {
                treeholechance -= 10;
                IBlockState state = woodBlock.func_176223_P().func_177226_a(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.getWet(EnumFacing.field_176754_o[rand.nextInt(4)])));
                BlockPos blockpos = position.func_177981_b(j2);
                if (stateMap.containsKey(blockpos)) {
                    stateMap.replace(blockpos, state);
                    continue;
                }
                stateMap.put(blockpos, state);
                continue;
            }
            BlockPos blockpos = position.func_177981_b(j2);
            IBlockState state = woodBlock.func_176223_P().func_177226_a(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y));
            if (stateMap.containsKey(blockpos)) {
                stateMap.replace(blockpos, state);
                continue;
            }
            stateMap.put(blockpos, state);
        }
        rubberTreesList.add(stateMap);
    }
}

