/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.rubbertree;

import com.denfop.IUItem;
import com.denfop.integration.jei.rubbertree.RubberTreeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RubberTreeWrapper
implements IRecipeWrapper {
    private final Map<BlockPos, IBlockState> map;
    int rotare = 0;

    public RubberTreeWrapper(RubberTreeHandler container) {
        this.map = container.map;
    }

    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ArrayList blockStates = new ArrayList();
        this.map.forEach((pos, state) -> {
            if (!blockStates.contains(state)) {
                list.add(new ItemStack(state.func_177230_c()));
                blockStates.add(state);
            }
        });
        return list;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.getInputs());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((Item)IUItem.rawLatex));
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78279_b("->", 165, 60, recipeWidth - 5, 0x404040);
        minecraft.field_71466_p.func_78279_b("+", 30, 60, recipeWidth - 5, 0x404040);
        if (minecraft.field_71439_g.field_70170_p != null) {
            if (minecraft.field_71439_g.field_70170_p.field_73011_w.getWorldTime() % 10L == 0L) {
                ++this.rotare;
            }
            if (this.rotare >= 180) {
                this.rotare = -180;
            }
        }
        int length = 5;
        int width = 4;
        int height = 10;
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179091_B();
        float maxDimension = Math.max(Math.max(width, height), length);
        float guiMaxDimension = 300.0f;
        float scale = guiMaxDimension / maxDimension / 2.0f;
        GL11.glTranslatef((float)130.0f, (float)40.0f, (float)100.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        Map<BlockPos, IBlockState> blocks = this.map;
        for (Map.Entry<BlockPos, IBlockState> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            IBlockState state = entry.getValue();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(pos.func_177958_n() - width / 2), (float)(pos.func_177956_o() - height / 2), (float)(pos.func_177952_p() - length / 2));
            IBakedModel model = blockRenderer.func_184389_a(state);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            blockRenderer.func_175019_b().func_178267_a((IBlockAccess)minecraft.field_71439_g.field_70170_p, model, state, BlockPos.field_177992_a, buffer, false);
            buffer.func_178969_c(0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
        GlStateManager.func_179101_C();
    }
}

