/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.squeezer;

import com.denfop.IUItem;
import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerHandler {
    private static final List<SqueezerHandler> recipes = new ArrayList<SqueezerHandler>();
    private final ItemStack input;
    private final FluidStack output;

    public SqueezerHandler(ItemStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<SqueezerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SqueezerHandler.initRecipes();
        }
        return recipes;
    }

    public static SqueezerHandler addRecipe(ItemStack input, FluidStack output) {
        SqueezerHandler recipe = new SqueezerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        SqueezerHandler.addRecipe(new ItemStack((Item)IUItem.rawLatex), new FluidStack(FluidName.fluidrawlatex.getInstance(), 100));
        SqueezerHandler.addRecipe(new ItemStack(Items.field_151081_bc), new FluidStack(FluidName.fluidseedoil.getInstance(), 35));
        SqueezerHandler.addRecipe(new ItemStack(Items.field_151080_bb), new FluidStack(FluidName.fluidseedoil.getInstance(), 35));
        SqueezerHandler.addRecipe(new ItemStack((Item)IUItem.crops), new FluidStack(FluidName.fluidseedoil.getInstance(), 50));
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

