/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.squeezer;

import com.denfop.integration.jei.squeezer.SqueezerHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SqueezerWrapper
implements IRecipeWrapper {
    private final FluidStack outputstack;
    private final ItemStack inputstack;

    public SqueezerWrapper(SqueezerHandler container) {
        this.inputstack = container.getInput();
        this.outputstack = container.getOutput();
    }

    public ItemStack getInputstack() {
        return this.inputstack;
    }

    public FluidStack getOutputstack() {
        return this.outputstack;
    }

    public List<List<ItemStack>> getInputs() {
        ItemStack inputs = this.inputstack;
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        stack.add(inputs);
        return Collections.singletonList(stack);
    }

    public List<FluidStack> getOutputs() {
        return new ArrayList<FluidStack>(Collections.singleton(this.outputstack));
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.getInputs());
        ingredients.setOutputs(VanillaTypes.FLUID, this.getOutputs());
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.field_71466_p.func_78279_b("+", 30, 38, recipeWidth - 5, 0x404040);
    }
}

