/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.sunnarium;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockSunnariumMaker;
import com.denfop.integration.jei.sunnarium.SunnariumWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SunnariumCategory
extends Gui
implements IRecipeCategory<SunnariumWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public SunnariumCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GuiSunnariumMaker.png"), 3, 3, 140, 77);
    }

    @Nonnull
    public String getUid() {
        return BlockSunnariumMaker.gen_sunnarium_plate.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.sunnariumpanelmaker).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        int xScale = (int)(17.0f * (float)this.progress / 100.0f);
        int xScale1 = (int)(13.0f * (float)this.progress / 100.0f);
        if ((float)xScale > 17.0f) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(9, 73 - energylevel, 176, 14 - energylevel, 14, energylevel);
        this.func_73729_b(46, 21, 177, 20, xScale + 1, 33);
        this.func_73729_b(82, 21, 177, 56, xScale1 + 1, 33);
    }

    public void setRecipe(IRecipeLayout layout, SunnariumWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 28, 17);
        isg.set(0, recipes.getInput());
        isg.init(1, true, 64, 17);
        isg.set(1, recipes.getInput1());
        isg.init(2, true, 28, 39);
        isg.set(2, recipes.getInput2());
        isg.init(3, true, 64, 39);
        isg.set(3, recipes.getInput3());
        isg.init(4, false, 99, 28);
        isg.set(4, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GuiSunnariumMaker.png");
    }
}

