/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.aqua;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.integration.jei.worldcollector.aqua.AquaWrapper;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AquaCategory
extends Gui
implements IRecipeCategory<AquaWrapper> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public AquaCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guiwaterassembler.png"), 5, 5, 140, 75);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine3.aqua_assembler.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.basemachine2, 1, 35).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(51.0f * (float)this.energy / 100.0f, 51.0f);
        int xScale = 34 * this.progress / 100;
        if (xScale > 34) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(26, 63 - energylevel, 179, 53 - energylevel, 5, energylevel);
        this.func_73729_b(61, 29, 177, 60, xScale, 18);
    }

    public void setRecipe(IRecipeLayout layout, AquaWrapper recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 38, 18);
        isg.set(0, recipes.getInput());
        isg.init(2, false, 104, 28);
        isg.set(2, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiwaterassembler.png");
    }
}

