/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.oc;

import com.denfop.api.IStorage;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.integration.oc.MultiMachineAdapter;
import com.denfop.integration.oc.QuantumQuarryAdapter;
import com.denfop.integration.oc.Storage;
import com.denfop.integration.oc.WindWaterAdapter;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.tiles.mechanism.quarry.TileBaseQuantumQuarry;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class OCIntegration {
    public static void init() {
        OCIntegration.initOC();
    }

    @Optional.Method(modid="opencomputers")
    public static void initOC() {
        Driver.add((DriverBlock)new OCStorageAdapter());
        Driver.add((DriverBlock)new OCWindWaterAdapter());
        Driver.add((DriverBlock)new OCQuantumQuarryAdapter());
        Driver.add((DriverBlock)new OCMultiMachineAdapter());
    }

    public static class OCWindWaterAdapter
    extends DriverSidedTileEntity {
        public Class<?> getTileEntityClass() {
            return IWindMechanism.class;
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
            return new WindWaterAdapter((IWindMechanism)world.func_175625_s(pos));
        }
    }

    public static class OCStorageAdapter
    extends DriverSidedTileEntity {
        public Class<?> getTileEntityClass() {
            return IStorage.class;
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
            return new Storage((IStorage)world.func_175625_s(pos));
        }
    }

    public static class OCQuantumQuarryAdapter
    extends DriverSidedTileEntity {
        public Class<?> getTileEntityClass() {
            return TileBaseQuantumQuarry.class;
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
            return new QuantumQuarryAdapter((TileBaseQuantumQuarry)world.func_175625_s(pos));
        }
    }

    public static class OCMultiMachineAdapter
    extends DriverSidedTileEntity {
        public Class<?> getTileEntityClass() {
            return TileMultiMachine.class;
        }

        public AbstractManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
            return new MultiMachineAdapter((TileMultiMachine)world.func_175625_s(pos));
        }
    }
}

