/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.gui.ITypeSlot;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.utils.ModUtils;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class InvSlot
extends AbstractList<ItemStack>
implements ITypeSlot {
    public IAdvInventory<?> base;
    protected TypeItemSlot typeItemSlot;
    protected NonNullList<ItemStack> contents;
    protected int stackSizeLimit;

    public InvSlot(IAdvInventory<?> base, TypeItemSlot typeItemSlot, int count) {
        this.contents = NonNullList.func_191197_a((int)count, (Object)ItemStack.field_190927_a);
        this.base = base;
        this.typeItemSlot = typeItemSlot;
        this.stackSizeLimit = 64;
        base.addInventorySlot(this);
    }

    public InvSlot(int count) {
        this.contents = NonNullList.func_191197_a((int)count, (Object)ItemStack.field_190927_a);
        this.base = null;
        this.typeItemSlot = null;
    }

    @Override
    public void clear() {
        this.contents = NonNullList.func_191197_a((int)this.size(), (Object)ItemStack.field_190927_a);
        this.stackSizeLimit = 64;
    }

    public boolean acceptAllOrIndex() {
        return true;
    }

    public TypeItemSlot getTypeItemSlot() {
        return this.typeItemSlot;
    }

    public void setTypeItemSlot(TypeItemSlot typeItemSlot) {
        this.typeItemSlot = typeItemSlot;
    }

    public List<ItemStack> getContents() {
        return this.contents;
    }

    public void readFromNbt(NBTTagCompound nbt) {
        NBTTagList contentsTag = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < contentsTag.func_74745_c(); ++i) {
            ItemStack stack;
            NBTTagCompound contentTag = contentsTag.func_150305_b(i);
            if (i >= this.size() || ModUtils.isEmpty(stack = new ItemStack(contentTag))) continue;
            this.putFromNBT(i, stack);
        }
        this.onChanged();
    }

    @Override
    public boolean add(List<ItemStack> stacks) {
        boolean added = false;
        for (ItemStack stack : stacks) {
            added = added || this.add(stack);
        }
        return added;
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public int addExperimental(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.addExperimental(stack, false);
    }

    public int addExperimental(ItemStack stack, boolean simulate) {
        if (stack != null && !stack.func_190926_b()) {
            int count = stack.func_190916_E();
            int minSlot = this.size();
            for (int i = 0; i < this.size(); ++i) {
                ItemStack stack1 = this.get(i);
                if (stack1.func_190926_b()) {
                    if (i >= minSlot) continue;
                    minSlot = i;
                    continue;
                }
                if (!stack1.func_77969_a(stack)) continue;
                if (stack1.func_190916_E() + count <= stack.func_77976_d()) {
                    if (stack.func_77978_p() == null && stack1.func_77978_p() == null) {
                        if (!simulate) {
                            stack1.func_190917_f(stack.func_190916_E());
                        }
                        return 0;
                    }
                    if (!ModUtils.checkNbtEquality(stack.func_77978_p(), this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        stack1.func_190917_f(count);
                    }
                    return 0;
                }
                int maxFill = stack1.func_77976_d() - stack1.func_190916_E();
                if (maxFill == 0) continue;
                maxFill = Math.min(count, maxFill);
                count -= maxFill;
                stack1.func_190917_f(maxFill);
            }
            if (count != 0) {
                if (minSlot != this.size()) {
                    if (!simulate) {
                        this.put(minSlot, ModUtils.setSize(stack, count));
                    }
                    return 0;
                }
                return count;
            }
            return count;
        }
        return 0;
    }

    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    public boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).func_190926_b()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                        }
                        return true;
                    }
                    if (!ModUtils.checkNbtEquality(stack.func_77978_p(), this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                    }
                    return true;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.put(minSlot, stack.func_77946_l());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public NBTTagCompound writeToNbt(NBTTagCompound nbt) {
        NBTTagList contentsTag = new NBTTagList();
        for (ItemStack content : this.contents) {
            NBTTagCompound contentTag = new NBTTagCompound();
            content.func_77955_b(contentTag);
            contentsTag.func_74742_a((NBTBase)contentTag);
        }
        nbt.func_74782_a("Items", (NBTBase)contentsTag);
        return nbt;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack stack : this.contents) {
            if (ModUtils.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(int index) {
        return ModUtils.isEmpty((ItemStack)this.contents.get(index));
    }

    public ItemStack get() {
        return this.get(0);
    }

    @Override
    public ItemStack get(int index) {
        return (ItemStack)this.contents.get(index % this.size());
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    protected void putFromNBT(int index, ItemStack content) {
        this.contents.set(index, (Object)content);
    }

    public void put(int index, ItemStack content) {
        this.contents.set(index, (Object)content);
        this.onChanged();
    }

    public void clear(int index) {
        this.put(index, ItemStack.field_190927_a);
    }

    public void onChanged() {
    }

    public boolean accepts(ItemStack stack, int index) {
        return true;
    }

    public boolean canInput() {
        return this.typeItemSlot == TypeItemSlot.INPUT || this.typeItemSlot == TypeItemSlot.INPUT_OUTPUT;
    }

    public boolean canOutput() {
        return this.typeItemSlot == TypeItemSlot.OUTPUT || this.typeItemSlot == TypeItemSlot.INPUT_OUTPUT;
    }

    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    @Override
    public ItemStack set(int i, ItemStack empty) {
        this.contents.set(i, (Object)empty);
        return empty;
    }

    public boolean canShift() {
        return true;
    }

    public void update() {
    }

    public static enum TypeItemSlot {
        INPUT,
        OUTPUT,
        INPUT_OUTPUT,
        NONE;


        public boolean isInput() {
            return this == INPUT || this == INPUT_OUTPUT;
        }

        public boolean isOutput() {
            return this == OUTPUT || this == INPUT_OUTPUT;
        }
    }
}

