/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.ItemAdditionModule;
import com.denfop.items.modules.ItemQuarryModule;
import com.denfop.tiles.base.TileAnalyzer;
import com.denfop.tiles.mechanism.quarry.TileBaseQuantumQuarry;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class InvSlotAnalyzer
extends InvSlot
implements ITypeSlot {
    private final int type;
    private final TileAnalyzer tile;
    private int stackSizeLimit;

    public InvSlotAnalyzer(TileAnalyzer base1, String name, int count, int type) {
        super(base1, InvSlot.TypeItemSlot.INPUT, count);
        this.type = type;
        this.stackSizeLimit = 1;
        this.tile = base1;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        if (this.type == 0) {
            return EnumTypeSlot.QUARRY1;
        }
        return EnumTypeSlot.BLOCKS;
    }

    @Override
    public void update() {
        if (this.type == 0) {
            this.tile.blacklist = this.getblacklist();
            this.tile.whitelist = this.getwhitelist();
            this.tile.size = this.getChunksize();
            this.tile.lucky = this.lucky();
            this.tile.macerator = this.macerator();
            this.tile.comb_macerator = this.comb_macerator();
            this.tile.polisher = this.polisher();
            this.tile.consume = this.getenergycost();
            this.tile.update_chunk();
            this.tile.furnace = this.getFurnaceModule();
        }
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        if (this.type == 0) {
            this.tile.blacklist = this.getblacklist();
            this.tile.whitelist = this.getwhitelist();
            this.tile.size = this.getChunksize();
            this.tile.lucky = this.lucky();
            this.tile.consume = this.getenergycost();
            this.tile.macerator = this.macerator();
            this.tile.polisher = this.polisher();
            this.tile.comb_macerator = this.comb_macerator();
            this.tile.furnace = this.getFurnaceModule();
        }
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (this.type == 0) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i).func_190926_b() || this.get(i).func_77952_i() != itemStack.func_77952_i() || this.get(i).func_77973_b() != itemStack.func_77973_b() || !(itemStack.func_77973_b() instanceof ItemQuarryModule)) continue;
                return false;
            }
            return itemStack.func_77973_b() instanceof ItemQuarryModule || itemStack.func_77973_b().equals(IUItem.quarrymodule) || itemStack.func_77973_b() instanceof ItemAdditionModule && itemStack.func_77952_i() == 10;
        }
        if (this.type == 1) {
            if (OreDictionary.getOreIDs((ItemStack)itemStack).length > 0) {
                int id = OreDictionary.getOreIDs((ItemStack)itemStack)[0];
                String name = OreDictionary.getOreName((int)id);
                return name.startsWith("ore");
            }
            return false;
        }
        return false;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public boolean quarry() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !this.get(i).func_77973_b().equals(IUItem.quarrymodule)) continue;
            return true;
        }
        return false;
    }

    public boolean macerator() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemQuarryModule) || this.get(i).func_77952_i() != 14) continue;
            return true;
        }
        return false;
    }

    public boolean comb_macerator() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemQuarryModule) || this.get(i).func_77952_i() != 15) continue;
            return true;
        }
        return false;
    }

    public boolean polisher() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemQuarryModule) || this.get(i).func_77952_i() != 16) continue;
            return true;
        }
        return false;
    }

    public int lucky() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemQuarryModule) || this.get(i).func_77952_i() < 6 || this.get(i).func_77952_i() >= 9) continue;
            return this.get(i).func_77952_i() - 5;
        }
        return 0;
    }

    public boolean getFurnaceModule() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemQuarryModule) || this.get(i).func_77952_i() != 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getblacklist() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || this.get(i).func_77952_i() != 12) continue;
            NBTTagCompound nbt = ModUtils.nbt(this.get(i));
            int size = nbt.func_74762_e("size");
            for (int j = 0; j < size; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(this.get(i), l);
                list.add(temp);
            }
        }
        return list;
    }

    public List<String> getwhitelist() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || this.get(i).func_77952_i() != 13) continue;
            NBTTagCompound nbt = ModUtils.nbt(this.get(i));
            int size = nbt.func_74762_e("size");
            for (int j = 0; j < size; ++j) {
                String l = "number_" + j;
                String temp = ModUtils.NBTGetString(this.get(i), l);
                list.add(temp);
            }
            break;
        }
        return list;
    }

    public boolean CheckBlackList(List<String> list, String name) {
        if (list.isEmpty()) {
            return false;
        }
        return !list.contains(name);
    }

    public boolean CheckWhiteList(List<String> list, String name) {
        if (list.isEmpty()) {
            return true;
        }
        return list.contains(name);
    }

    public int getChunksize() {
        int size = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemQuarryModule) || this.get(i).func_77952_i() <= 8 || this.get(i).func_77952_i() > 11) continue;
            size = this.get(i).func_77952_i() - 8;
            return size;
        }
        return size;
    }

    public boolean getwirelessmodule() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemAdditionModule) || this.get(i).func_77952_i() != 10) continue;
            return true;
        }
        return false;
    }

    public List<Integer> wirelessmodule() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemAdditionModule) || this.get(i).func_77952_i() != 10) continue;
            NBTTagCompound nbttagcompound = ModUtils.nbt(this.get(i));
            int x = nbttagcompound.func_74762_e("Xcoord");
            int y = nbttagcompound.func_74762_e("Ycoord");
            int z = nbttagcompound.func_74762_e("Zcoord");
            if (x == 0 || y == 0 || z == 0) break;
            list.add(x);
            list.add(y);
            list.add(z);
            break;
        }
        return list;
    }

    public double getenergycost(TileBaseQuantumQuarry target1) {
        double energy = target1.energyconsume;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemQuarryModule) || this.get(i).func_77952_i() <= 0 || this.get(i).func_77952_i() >= 6) continue;
            double proccent = this.get(i).func_77952_i();
            proccent *= 0.05;
            proccent *= energy;
            proccent = energy - proccent;
            return proccent;
        }
        return energy;
    }

    public double getenergycost() {
        double energy = 1000.0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b() || !(this.get(i).func_77973_b() instanceof ItemQuarryModule) || this.get(i).func_77952_i() <= 0 || this.get(i).func_77952_i() >= 6) continue;
            double proccent = this.get(i).func_77952_i();
            proccent *= 0.05;
            proccent *= energy;
            proccent = energy - proccent;
            return proccent;
        }
        return energy;
    }
}

