/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.EnumQuarryModules;
import com.denfop.items.modules.EnumQuarryType;
import com.denfop.items.modules.ItemQuarryModule;
import com.denfop.tiles.base.TileEntityAutoDigger;
import net.minecraft.item.ItemStack;

public class InvSlotDigger
extends InvSlot
implements ITypeSlot {
    public final TileEntityAutoDigger tile;
    public int stackSizeLimit;

    public InvSlotDigger(TileEntityAutoDigger base1) {
        super(base1, InvSlot.TypeItemSlot.INPUT, 3);
        this.tile = base1;
        this.stackSizeLimit = 1;
    }

    @Override
    public void update() {
        this.tile.consume = this.tile.energyconsume;
        this.tile.col = 1;
        this.tile.chance = 0;
        this.tile.furnace = false;
        this.tile.comb_mac_enabled = false;
        this.tile.mac_enabled = false;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b()) continue;
            ItemStack type1 = this.get(i);
            EnumQuarryModules module = EnumQuarryModules.getFromID(type1.func_77952_i());
            EnumQuarryType type = module.type;
            switch (type) {
                case SPEED: {
                    break;
                }
                case DEPTH: {
                    this.tile.col = module.efficiency * module.efficiency;
                    break;
                }
                case LUCKY: {
                    this.tile.chance = module.efficiency;
                    break;
                }
                case FURNACE: {
                    this.tile.furnace = true;
                    break;
                }
                case COMB_MAC: {
                    this.tile.comb_mac_enabled = true;
                    break;
                }
                case MACERATOR: {
                    this.tile.mac_enabled = true;
                }
            }
            this.tile.consume += this.tile.energyconsume * module.cost;
        }
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        this.tile.consume = this.tile.energyconsume;
        this.tile.col = 1;
        this.tile.chance = 0;
        this.tile.furnace = false;
        this.tile.comb_mac_enabled = false;
        this.tile.mac_enabled = false;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).func_190926_b()) continue;
            ItemStack type1 = this.get(i);
            EnumQuarryModules module = EnumQuarryModules.getFromID(type1.func_77952_i());
            EnumQuarryType type = module.type;
            switch (type) {
                case SPEED: {
                    break;
                }
                case DEPTH: {
                    this.tile.col = module.efficiency * module.efficiency;
                    break;
                }
                case LUCKY: {
                    this.tile.chance = module.efficiency;
                    break;
                }
                case FURNACE: {
                    this.tile.furnace = true;
                    break;
                }
                case COMB_MAC: {
                    this.tile.comb_mac_enabled = true;
                    break;
                }
                case MACERATOR: {
                    this.tile.mac_enabled = true;
                }
            }
            this.tile.consume += this.tile.energyconsume * module.cost;
        }
        this.tile.inputslot.update();
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        return itemStack.func_77973_b() instanceof ItemQuarryModule && EnumQuarryModules.getFromID((int)itemStack.func_77952_i()).type != EnumQuarryType.WHITELIST && EnumQuarryModules.getFromID((int)itemStack.func_77952_i()).type != EnumQuarryType.BLACKLIST;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        return EnumTypeSlot.QUARRY1;
    }
}

