/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.ElectricItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.invslot.InvSlot;
import com.denfop.utils.ModUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class InvSlotDischarge
extends InvSlot {
    public int tier;
    public boolean allowRedstoneDust;

    public InvSlotDischarge(IAdvInventory<?> base, InvSlot.TypeItemSlot typeItemSlot, int tier) {
        this(base, typeItemSlot, tier, false);
    }

    public InvSlotDischarge(IAdvInventory<?> base, int tier) {
        this(base, InvSlot.TypeItemSlot.INPUT, tier);
    }

    public InvSlotDischarge(IAdvInventory<?> base, InvSlot.TypeItemSlot typeItemSlot, int tier, boolean allowRedstoneDust) {
        super(base, typeItemSlot, 1);
        this.tier = tier;
        this.allowRedstoneDust = allowRedstoneDust;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.BATTERY;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        if (this.allowRedstoneDust && stack.func_77973_b() == Items.field_151137_ax) {
            return true;
        }
        if (stack.func_77973_b() instanceof IEnergyItem) {
            return ElectricItem.manager.discharge(stack, 2.147483647E9, this.tier, true, true, true) > 0.0;
        }
        return false;
    }

    public double discharge(double amount, boolean ignoreLimit) {
        if (amount <= 0.0) {
            return 0.0;
        }
        ItemStack stack = this.get(0);
        if (ModUtils.isEmpty(stack)) {
            return 0.0;
        }
        double realAmount = ElectricItem.manager.discharge(stack, amount, this.tier, ignoreLimit, true, false);
        if (realAmount <= 0.0) {
            realAmount = ModUtils.getEnergyValue(stack);
            if (realAmount <= 0.0) {
                return 0.0;
            }
            stack.func_190918_g(1);
            this.put(0, stack);
        }
        return realAmount;
    }

    public double dischargeWithRedstone(double capacity, double amount) {
        ItemStack stack = this.get();
        if (stack.func_190926_b()) {
            return 0.0;
        }
        double canAdd = capacity * 0.2;
        int size = stack.func_190916_E();
        int needRemove = (int)Math.min(amount / canAdd, (double)size);
        if (needRemove <= 0) {
            return 0.0;
        }
        this.put(0, ModUtils.decSize(stack, needRemove));
        return (double)needRemove * canAdd;
    }

    public void setTier(int tier1) {
        this.tier = tier1;
    }
}

