/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.invslot.InvSlot;
import com.denfop.utils.ModUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.commons.lang3.mutable.MutableObject;

public class InvSlotFluid
extends InvSlot {
    private TypeFluidSlot typeFluidSlot;

    public InvSlotFluid(IAdvInventory<?> base1, int count) {
        this(base1, InvSlot.TypeItemSlot.INPUT, count, TypeFluidSlot.INPUT);
    }

    public InvSlotFluid(IAdvInventory<?> base1, InvSlot.TypeItemSlot typeItemSlot1, int count, TypeFluidSlot typeFluidSlot1) {
        super(base1, typeItemSlot1, count);
        this.typeFluidSlot = typeFluidSlot1;
    }

    public void setTypeFluidSlot(TypeFluidSlot typeFluidSlot) {
        this.typeFluidSlot = typeFluidSlot;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        if (ModUtils.isEmpty(stack)) {
            return false;
        }
        if (FluidUtil.getFluidHandler((ItemStack)stack) == null) {
            return false;
        }
        if (this.typeFluidSlot == TypeFluidSlot.INPUT || this.typeFluidSlot == TypeFluidSlot.INPUT_OUTPUT) {
            ItemStack singleStack;
            IFluidHandlerItem handler;
            FluidStack containerFluid = null;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandlerItem)(singleStack = ModUtils.setSize(stack, 1)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
                containerFluid = handler.drain(Integer.MAX_VALUE, false);
            }
            if (containerFluid != null && containerFluid.amount > 0 && this.acceptsLiquid(containerFluid.getFluid())) {
                return true;
            }
        }
        return (this.typeFluidSlot == TypeFluidSlot.OUTPUT || this.typeFluidSlot == TypeFluidSlot.INPUT_OUTPUT) && FluidUtil.getFluidHandler((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack) == null;
    }

    public FluidStack drain(Fluid fluid, int maxAmount, MutableObject<ItemStack> output, boolean simulate) {
        output.setValue(null);
        if (fluid != null && !this.acceptsLiquid(fluid)) {
            return null;
        }
        if (this.typeFluidSlot != TypeFluidSlot.INPUT && this.typeFluidSlot != TypeFluidSlot.INPUT_OUTPUT) {
            return null;
        }
        ItemStack stack = this.get().func_77946_l();
        stack.func_190920_e(1);
        if (ModUtils.isEmpty(stack)) {
            return null;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        FluidStack fs = fluid == null ? handler.drain(maxAmount, true) : handler.drain(new FluidStack(fluid, maxAmount), true);
        if (fs != null && fs.amount > 0) {
            ItemStack inPlace = handler.getContainer();
            assert (fs.amount > 0);
            if (!this.acceptsLiquid(fs.getFluid())) {
                return null;
            }
            output.setValue((Object)inPlace);
            if (!simulate) {
                this.get().func_190918_g(1);
            }
            return fs;
        }
        return null;
    }

    public int fill(FluidStack fs, MutableObject<ItemStack> output, boolean simulate) {
        output.setValue(null);
        if (fs != null && fs.amount > 0) {
            FluidStack fsChange;
            if (this.typeFluidSlot != TypeFluidSlot.OUTPUT && this.typeFluidSlot != TypeFluidSlot.INPUT_OUTPUT) {
                return 0;
            }
            ItemStack stack = this.get().func_77946_l();
            stack.func_190920_e(1);
            if (ModUtils.isEmpty(stack)) {
                return 0;
            }
            IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            int amount = handler.fill(fsChange = fs.copy(), true);
            if (amount <= 0) {
                return 0;
            }
            fsChange.amount = amount;
            FluidStack fillTestFs = fs.copy();
            fillTestFs.amount = Integer.MAX_VALUE;
            handler.fill(fillTestFs, false);
            ItemStack inPlace = stack = handler.getContainer();
            output.setValue((Object)inPlace);
            if (!simulate) {
                this.get().func_190918_g(1);
            }
            return fsChange.amount;
        }
        return 0;
    }

    public boolean transferToTank(IFluidTank tank, MutableObject<ItemStack> output, boolean simulate) {
        FluidStack fluid;
        if (this.isEmpty()) {
            return false;
        }
        int space = tank.getCapacity();
        Fluid fluidRequired = null;
        FluidStack tankFluid = tank.getFluid();
        if (tankFluid != null) {
            space -= tankFluid.amount;
            fluidRequired = tankFluid.getFluid();
        }
        if ((fluid = this.drain(fluidRequired, space, output, true)) == null) {
            return false;
        }
        int amount = tank.fill(fluid, !simulate);
        if (amount <= 0) {
            return false;
        }
        if (!simulate) {
            this.drain(fluidRequired, amount, output, false);
        }
        return true;
    }

    public boolean transferFromTank(IFluidTank tank, MutableObject<ItemStack> output, boolean simulate) {
        if (this.isEmpty()) {
            return false;
        }
        FluidStack tankFluid = tank.drain(tank.getFluidAmount(), false);
        if (tankFluid != null && tankFluid.amount > 0) {
            int amount = this.fill(tankFluid, output, simulate);
            if (amount <= 0) {
                return false;
            }
            if (!simulate) {
                tank.drain(amount, true);
            }
            return true;
        }
        return false;
    }

    public boolean processIntoTank(IFluidTank tank, InvSlotOutput outputSlot) {
        if (this.isEmpty()) {
            return false;
        }
        MutableObject output = new MutableObject();
        boolean wasChange = false;
        if (this.transferToTank(tank, (MutableObject<ItemStack>)output, true) && (ModUtils.isEmpty((ItemStack)output.getValue()) || outputSlot.canAdd((ItemStack)output.getValue()))) {
            wasChange = this.transferToTank(tank, (MutableObject<ItemStack>)output, false);
            if (!ModUtils.isEmpty((ItemStack)output.getValue())) {
                outputSlot.add((ItemStack)output.getValue());
            }
        }
        return wasChange;
    }

    public boolean processFromTank(IFluidTank tank, InvSlotOutput outputSlot) {
        if (!this.isEmpty() && tank.getFluidAmount() > 0) {
            MutableObject output = new MutableObject();
            boolean wasChange = false;
            if (this.transferFromTank(tank, (MutableObject<ItemStack>)output, true) && (ModUtils.isEmpty((ItemStack)output.getValue()) || outputSlot.canAdd((ItemStack)output.getValue()))) {
                wasChange = this.transferFromTank(tank, (MutableObject<ItemStack>)output, false);
                if (!ModUtils.isEmpty((ItemStack)output.getValue())) {
                    outputSlot.add((ItemStack)output.getValue());
                }
            }
            return wasChange;
        }
        return false;
    }

    protected boolean acceptsLiquid(Fluid fluid) {
        return true;
    }

    protected Iterable<Fluid> getPossibleFluids() {
        return null;
    }

    public static enum TypeFluidSlot {
        INPUT,
        OUTPUT,
        INPUT_OUTPUT;

    }
}

