/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.api.windsystem.IWindRotor;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemWaterRotor;
import com.denfop.tiles.hydroturbine.TileEntityHydroTurbineController;
import com.denfop.utils.DamageHandler;
import com.denfop.utils.ModUtils;
import net.minecraft.item.ItemStack;

public class InvSlotHydroTurbineRotor
extends InvSlot
implements ITypeSlot {
    private final TileEntityHydroTurbineController windGenerator;

    public InvSlotHydroTurbineRotor(TileEntityHydroTurbineController windGenerator) {
        super(windGenerator, InvSlot.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(1);
        this.windGenerator = windGenerator;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.WATER_ROTOR;
    }

    public int damage(int amount, double chance) {
        int damageApplied = 0;
        if (chance > 0.0 && this.windGenerator.func_145831_w().field_73012_v.nextInt(101) > (int)(chance * 100.0)) {
            return 0;
        }
        ItemStack stack = this.get(0);
        if (!ModUtils.isEmpty(stack)) {
            DamageHandler.damage(stack, amount, null);
            if ((double)DamageHandler.getDamage(stack) <= (double)DamageHandler.getMaxDamage(stack) * 0.75) {
                this.windGenerator.need_repair = true;
            }
        }
        return damageApplied;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        return stack.func_77973_b() instanceof ItemWaterRotor && ((IWindRotor)stack.func_77973_b()).getLevel() >= 1 && ((IWindRotor)stack.func_77973_b()).getLevel() <= 14;
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        this.windGenerator.change();
        if (!content.func_190926_b()) {
            this.windGenerator.energy.getEnergy().setSourceTier(this.windGenerator.getRotor().getSourceTier());
        } else {
            this.windGenerator.energy.getEnergy().setSourceTier(1);
        }
    }
}

