/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileCombinerMatter;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InvSlotMatter
extends InvSlot
implements ITypeSlot {
    private final TileCombinerMatter tile;
    private int stackSizeLimit = 4;

    public InvSlotMatter(TileCombinerMatter base1) {
        super(base1, InvSlot.TypeItemSlot.INPUT, 9);
        this.tile = base1;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.BLOCKS;
    }

    @Override
    public void update() {
        this.tile.energy.setCapacity(this.getMaxEnergy(this));
        this.tile.fluidTank.setCapacity(this.getFluidTank(this));
        this.tile.energycost = this.getcostEnergy(this);
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        this.tile.energy.setCapacity(this.getMaxEnergy(this));
        this.tile.fluidTank.setCapacity(this.getFluidTank(this));
        this.tile.energycost = this.getcostEnergy(this);
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        return itemStack.func_77973_b().equals(Item.func_150898_a((Block)IUItem.machines)) && itemStack.func_77952_i() <= 3 || itemStack.func_77969_a(new ItemStack((Block)IUItem.simplemachine, 1, 6)) || itemStack.func_77969_a(new ItemStack((Block)IUItem.pho_machine, 1, 12));
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public double getMattercostenergy(ItemStack stack) {
        int count = stack.func_77952_i();
        if (stack.func_77973_b().equals(Item.func_150898_a((Block)IUItem.machines))) {
            switch (count) {
                case 1: {
                    return 900000.0;
                }
                case 2: {
                    return 800000.0;
                }
                case 3: {
                    return 700000.0;
                }
            }
        }
        if (stack.func_77973_b().equals(Item.func_150898_a((Block)IUItem.pho_machine))) {
            return 600000.0;
        }
        return 1000000.0;
    }

    public double getMatterenergy(ItemStack stack) {
        int count = stack.func_77952_i();
        if (stack.func_77973_b().equals(Item.func_150898_a((Block)IUItem.machines))) {
            switch (count) {
                case 1: {
                    return 8000000.0;
                }
                case 2: {
                    return 6.4E7;
                }
                case 3: {
                    return 2.56E8;
                }
            }
        }
        if (stack.func_77973_b().equals(Item.func_150898_a((Block)IUItem.pho_machine))) {
            return 5.12E8;
        }
        return 5000000.0;
    }

    public double getMaxEnergy(InvSlotMatter inputSlot) {
        double maxEnergy = 0.0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).func_190926_b()) continue;
            maxEnergy += this.getMatterenergy(inputSlot.get(i)) * (double)inputSlot.get(i).func_190916_E();
        }
        return maxEnergy;
    }

    public double getcostEnergy(InvSlotMatter inputSlot) {
        double cost = 0.0;
        int k = 0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).func_190926_b()) continue;
            cost += this.getMattercostenergy(inputSlot.get(i)) * (double)inputSlot.get(i).func_190916_E();
            k += inputSlot.get(i).func_190916_E();
        }
        return cost / (double)k;
    }

    public int getFluidTank(InvSlotMatter inputSlot) {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).func_190926_b()) continue;
            count += this.getMattertank(inputSlot.get(i)) * inputSlot.get(i).func_190916_E();
        }
        return 1000 * count;
    }

    private int getMattertank(ItemStack itemStack) {
        int count = itemStack.func_77952_i();
        if (itemStack.func_77973_b().equals(Item.func_150898_a((Block)IUItem.machines))) {
            switch (count) {
                case 1: {
                    return 12;
                }
                case 2: {
                    return 14;
                }
                case 3: {
                    return 16;
                }
            }
        }
        if (itemStack.func_77973_b().equals(Item.func_150898_a((Block)IUItem.pho_machine))) {
            return 16;
        }
        return 10;
    }
}

