/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.ItemQuarryModule;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.TileModuleMachine;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class InvSlotModule
extends InvSlot
implements ITypeSlot {
    private final int type;
    private final TileModuleMachine tile;
    private int stackSizeLimit = 1;

    public InvSlotModule(TileEntityInventory base1, int type, int count) {
        super(base1, InvSlot.TypeItemSlot.INPUT_OUTPUT, count);
        this.type = type;
        this.tile = (TileModuleMachine)base1;
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        if (this.type == 0) {
            this.update();
        }
    }

    @Override
    public void update() {
        if (this.type == 0) {
            this.tile.listItems.clear();
            for (int i = 0; i < this.size(); ++i) {
                int id;
                String ore;
                if (this.get(i).func_190926_b() || this.tile.listItems.contains(ore = OreDictionary.getOreName((int)(id = OreDictionary.getOreIDs((ItemStack)this.get(i))[0])))) continue;
                this.tile.listItems.add(ore);
            }
        }
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (this.type == 0) {
            if (OreDictionary.getOreIDs((ItemStack)itemStack).length > 0) {
                int id = OreDictionary.getOreIDs((ItemStack)itemStack)[0];
                String ore = OreDictionary.getOreName((int)id);
                return ore.startsWith("ore") || ore.startsWith("gem") || ore.startsWith("ingot") || ore.startsWith("dust") || ore.startsWith("shard");
            }
            return false;
        }
        return itemStack.func_77973_b() instanceof ItemQuarryModule && itemStack.func_77952_i() >= 12;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        switch (this.type) {
            case 0: {
                return EnumTypeSlot.BLOCKS;
            }
            case 1: {
                return EnumTypeSlot.LIST;
            }
        }
        return null;
    }
}

